/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.generator;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.extensionpoint.ChangesRecorder;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.report.changes.ChangesCategory;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class DefaultChangesRecorder
implements ChangesRecorder {
    private static final Logger logger = Logger.getLogger(DefaultChangesRecorder.class);

    public List<? extends Changeset> read(Long buildId, String repositoryName) {
        Build build = (Build)BuildManager.instance.get(buildId);
        if (build == null) {
            throw new QuickbuildException("Build " + buildId + " does not exist.");
        }
        ArrayList filters = Lists.newArrayList();
        filters.add(Restrictions.eq((String)"changesets.repository", (Object)repositoryName));
        return ChangesHelper.getBuildChangesets(build, filters, 0, -1, true);
    }

    public void write(Long buildId, String repositoryName, List<Changeset> changes) {
        Build build = (Build)BuildManager.instance.get(buildId);
        Repository repository = build.getConfiguration().findRepository(repositoryName);
        this.saveChanges(build, changes, repository);
    }

    protected ChangesCategory getCategory() {
        return (ChangesCategory)ReportHelper.getCategory(ChangesPlugin.class);
    }

    private List<Changeset> removeDuplicates(List<Changeset> changes, Repository<?> repository) {
        ArrayList result = Lists.newArrayList();
        HashSet keys = Sets.newHashSet();
        for (Changeset each : changes) {
            if (!keys.contains(each.getId())) {
                result.add(each);
            } else {
                Context.getLogger().warn("Repository " + repository.getName() + " contains duplicate change sets [" + each.getId() + "]");
            }
            keys.add(each.getId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChanges(Build build, List<Changeset> changes, Repository<?> repository) {
        ChangesCategory category = this.getCategory();
        File categoryDir = new File(build.getPublishDir(), "reports/" + category.getId());
        Lock lock = LockUtils.lockForWrite((File)categoryDir);
        try {
            FileUtils.createDir((File)categoryDir);
            category.writeVersionFile(categoryDir);
            File dbDir = category.getChangesDirOfBuild(build);
            FileUtils.createDir((File)dbDir);
            CategoryDb db = category.getCategoryDb(dbDir);
            try {
                db.open(DbStore.Mode.READ_WRITE, "DefaultChangesRecorder::saveChanges");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Database in directory: " + db + " opened successfully."));
                }
                DataReport changesetsReport = category.createReport("changesets");
                DataReport modificationsReport = category.createReport("modifications");
                Long buildId = build.getId();
                String repositoryName = repository.getName();
                logger.info((Object)"Deleting all old changesets and modifications ...");
                SqlBuilder query = SqlBuilder.deleteFrom((String)"modifications").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)buildId), Restrictions.eq((String)"repository", (Object)repositoryName)});
                db.update(query);
                query = SqlBuilder.deleteFrom((String)"changesets").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)buildId), Restrictions.eq((String)"repository", (Object)repositoryName)});
                db.update(query);
                logger.info((Object)("Saving all changesets for build " + buildId + " in repository " + repositoryName));
                List<Changeset> noDuplicates = this.removeDuplicates(changes, repository);
                for (Changeset each : noDuplicates) {
                    String userName;
                    User u;
                    DataRow changeRow = new DataRow(changesetsReport);
                    ChangesHelper.changesetToDataRow(new BuildChangeset(repositoryName, each), changeRow);
                    changeRow.setValue("buildId", (Object)buildId);
                    if (repository != null && (u = UserManager.instance.get(userName = repository.getUserName(each.getUser()))) != null) {
                        changeRow.setValue("userId", (Object)u.getId());
                    }
                    db.persistRow(changeRow);
                    for (Modification m : each.getModifications()) {
                        DataRow mRow = new DataRow(modificationsReport);
                        mRow.setValue("buildId", (Object)buildId);
                        mRow.setValue("changeId", (Object)each.getId());
                        mRow.setValue("repository", (Object)repositoryName);
                        mRow.setValue("fileName", (Object)m.getPath());
                        mRow.setValue("action", (Object)m.getAction().name());
                        mRow.setValue("pathType", m.getPathType() == null ? null : m.getPathType().name());
                        mRow.setValue("edition", (Object)m.getEdition());
                        mRow.setValue("previousEdition", (Object)m.getPreviousEdition());
                        db.persistRow(mRow);
                    }
                }
                DataReport statsReport = category.createReport("stats");
                DataRow sRow = statsReport.addRow();
                String sql = "SELECT COUNT(*) AS commits, SUM(modifications) AS modifications, SUM(added) AS added, SUM(modified) AS modified, SUM(deleted) AS deleted FROM changesets";
                Map map = db.queryForMap(sql);
                sRow.setValue("buildId", (Object)build.getId());
                sRow.fromMap(map);
                sql = "SELECT COUNT(DISTINCT FILENAME) AS files FROM modifications";
                Long files = db.queryForLong(sql);
                sRow.setValue("files", (Object)files.intValue());
                logger.info((Object)("Saving commit stats for build " + buildId));
                SqlBuilder sb = SqlBuilder.deleteFrom((String)"stats").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
                db.update(sb);
                category.saveReport(db, statsReport);
            }
            finally {
                db.close();
            }
        }
        catch (Throwable e) {
            Context.getLogger().error("Failed writing below changesets to database\n" + this.dump(changes));
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private String dump(List<Changeset> changes) {
        StringBuffer sb = new StringBuffer();
        for (Changeset each : changes) {
            sb.append(each).append("\n");
        }
        return sb.toString();
    }
}

