/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.generator;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.persistent.PersistBuildReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.LastBuildsFile;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ChangesStatsGenerator
extends PersistBuildReportGenerator {
    private static final long serialVersionUID = 1L;

    public ChangesStatsGenerator(ReportCategory category) {
        super(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        ReportCategory category = this.getCategory();
        GeneratorContext context = this.getContext();
        Build build = context.getCurrentBuild();
        File sourceDir = category.getReportDirOfBuild(build, "DEFAULT");
        File workingDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        CategoryDb buildDb = category.getCategoryDb(sourceDir);
        CategoryDb statsDb = category.getCategoryDb(workingDir);
        try {
            buildDb.open(DbStore.Mode.READ_ONLY, "ChangesStatsGenerator::generate");
            statsDb.open(DbStore.Mode.READ_WRITE, "ChangesStatsGenerator::generate");
            LastBuildsFile lbf = new LastBuildsFile(workingDir);
            lbf.load();
            List ids = lbf.getBuildIds();
            if (ids.size() > 0) {
                Long each;
                Collections.sort(ids);
                Collections.reverse(ids);
                Build previousFinished = build.getPreviousFinished();
                boolean hasRemoved = false;
                Long previousId = previousFinished == null ? Long.valueOf(0L) : previousFinished.getId();
                Iterator it = ids.iterator();
                while (it.hasNext() && (each = (Long)it.next()) > previousId) {
                    Context.getLogger().info("Deleting changes of build : " + each + " which may be already deleted.");
                    statsDb.update("DELETE FROM modifications WHERE buildId=" + each);
                    statsDb.update("DELETE FROM changesets WHERE buildId=" + each);
                    statsDb.update("DELETE FROM stats WHERE buildId=" + each);
                    it.remove();
                    hasRemoved = true;
                }
                if (hasRemoved) {
                    lbf.setBuildIds(ids);
                    lbf.save();
                }
            }
            Context.getLogger().info("Deleting all changes with build id [" + build.getId() + "] which should not exist.");
            statsDb.update("DELETE FROM modifications WHERE buildId=" + build.getId());
            statsDb.update("DELETE FROM changesets WHERE buildId=" + build.getId());
            statsDb.update("DELETE FROM stats WHERE buildId=" + build.getId());
            Context.getLogger().debug("Saving changesets to statistics database");
            DataReport report = buildDb.loadReport("changesets", new Filter[0]);
            category.saveReport(statsDb, report);
            Context.getLogger().debug("Saving modifications to statistics database");
            report = buildDb.loadReport("modifications", new Filter[0]);
            category.saveReport(statsDb, report);
            Context.getLogger().debug("Saving changes stats data...");
            report = buildDb.loadReport("stats", new Filter[0]);
            SqlBuilder sql = SqlBuilder.deleteFrom((String)"stats").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
            statsDb.update(sql);
            category.saveReport(statsDb, report);
        }
        finally {
            try {
                buildDb.close();
            }
            finally {
                statsDb.close();
            }
        }
    }
}

