/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.changes.gadget.LatestCommitsRenderer;
import com.pmease.quickbuild.plugin.report.changes.renderer.changeset.column.CommitCountColumn;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportGadgetWithTable;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.List;

@Editable(name="Commits of Build", category={"Changes and Issues"})
public class LatestCommitsGadget
extends ReportGadgetWithTable {
    private static final long serialVersionUID = 1L;
    private boolean showModificationColumn = true;

    protected void checkPermission() {
        if (!SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            throw new AccessDeniedException("You have no permission to access build changes.");
        }
    }

    @Editable(name="Show Modifications", description="Whether show modification counts column or not.")
    public boolean isShowModificationColumn() {
        return this.showModificationColumn;
    }

    public void setShowModificationColumn(boolean showModificationColumn) {
        this.showModificationColumn = showModificationColumn;
    }

    public List<String> getReportsets() {
        return Lists.newArrayList((Object[])new String[]{"DEFAULT"});
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(ChangesPlugin.class);
    }

    protected TableRenderer createTableRenderer() {
        ReportCategory category = this.getCategory();
        LatestCommitsRenderer renderer = new LatestCommitsRenderer(category, this);
        if (this.isShowModificationColumn()) {
            renderer.addColumn(new CommitCountColumn(renderer));
        }
        renderer.setContentOnly(true);
        return renderer;
    }

    protected String getToTab() {
        return "By Changeset";
    }
}

