/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.changes.renderer.CommitStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.List;

@Editable(name="Commit Stats", order=20, category={"Changes and Issues"})
public class CommitStatsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;

    protected void checkPermission() {
        if (!SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            throw new AccessDeniedException("You have no permission to access build changes.");
        }
    }

    protected StatisticsRenderer createRenderer() {
        CommitStatsRenderer r = new CommitStatsRenderer(ReportHelper.getCategory(ChangesPlugin.class));
        r.setSimpleMode(true);
        return r;
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Commits", "Modifications"});
    }

    public List<String> getReportsets() {
        return Lists.newArrayList((Object[])new String[]{"DEFAULT"});
    }
}

