/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes.aggregation;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.changes.aggregation.ChangesAggregationStatsRenderer;
import com.pmease.quickbuild.plugin.report.changes.aggregation.ChangesAggregator;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.renderer.aggregation.AggregationStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.AggregatedLineChartGadget;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Commits Aggregated Stats", category={"Changes and Issues"})
public class ChangesAggregationStatsGadget
extends AggregatedLineChartGadget {
    private static final long serialVersionUID = 1L;

    protected AggregationStatsRenderer createRenderer() {
        ChangesAggregationStatsRenderer r = new ChangesAggregationStatsRenderer(ReportHelper.getCategory(ChangesPlugin.class));
        r.setSimpleMode(true);
        return r;
    }

    protected boolean isValidAggregation(Aggregation aggregation) {
        return aggregation.getClass().isAssignableFrom(ChangesAggregator.class);
    }

    protected String getAggregatedTabName() {
        return "Changes Aggregation";
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Commits", "Modifications", "Total Files"});
    }
}

