/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Comments Transformer", description="Define patterns below to tranform the commit messages to arbitary HTML pieces. For example, if you want to transform Bugzilla id found in comments to a hyperlink to the corresponding issue page, you can define the search pattern as: <code>(?&lt;!\\:)(?:#|bug:)(\\d+)(\\b|$)</code>and define the replace pattern as <code>#$1</code>", category={"Issue Tracker"})
public class GenericTransformerSetting {
    private String searchPattern;
    private String replacePattern;

    public static GenericTransformerSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (GenericTransformerSetting)PluginSettingHelper.findConfigurationSetting(ChangesPlugin.class, (Configuration)configuration, (boolean)true);
    }

    @Editable(name="Search Pattern", order=100, description="Defines the pattern to search in the commit comments. Please reference the <a target=\"_blank\" href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regulary expression</a> for the syntax.")
    @NotEmpty
    @Scriptable
    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    @Editable(name="Replace Pattern", order=200, description="Defines the pattern to replace with.Please reference the <a target=\"_blank\" href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regulary expression</a> for the syntax.")
    @NotEmpty
    @Scriptable
    public String getReplacePattern() {
        return this.replacePattern;
    }

    public void setReplacePattern(String replaceWith) {
        this.replacePattern = replaceWith;
    }

    public static void main(String[] args) {
        String searchPattern = "(?<!\\:)(?:#|bug:)(\\d+)(\\b|$)";
        String replacePattern = "<a target=\"_blank\" title=\"Click to open this issue a new window\" href=\"http://track.pmease.com/browse/$1\">#$1</a>";
        String comment = "Fix for :#134 bug:245";
        Pattern p = Pattern.compile(searchPattern);
        Matcher m = p.matcher(comment);
        while (m.find()) {
            System.out.println(m.group());
        }
        System.out.println(comment.replaceAll(searchPattern, replacePattern));
    }
}

