/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesCategory;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.DefaultCommentTransformer;
import com.pmease.quickbuild.plugin.report.changes.GenericTransformerSetting;
import com.pmease.quickbuild.plugin.report.changes.aggregation.ChangesAggregationOverviewGadget;
import com.pmease.quickbuild.plugin.report.changes.aggregation.ChangesAggregator;
import com.pmease.quickbuild.plugin.report.changes.contribution.ChangesBuildTab;
import com.pmease.quickbuild.plugin.report.changes.contribution.ChangesStatisticsTab;
import com.pmease.quickbuild.plugin.report.changes.gadget.CommitStatsGadget;
import com.pmease.quickbuild.plugin.report.changes.gadget.LatestCommitsGadget;
import com.pmease.quickbuild.plugin.report.changes.generator.ChangesStatsProvider;
import com.pmease.quickbuild.plugin.report.changes.generator.DefaultChangesRecorder;
import com.pmease.quickbuild.plugin.report.changes.localchanges.LocalChangesBuildTabContribution;
import com.pmease.quickbuild.plugin.report.changes.rest.ChangesResource;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.gadget.ReportGadgetProvider;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryBuildOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.ReportSummaryContribution;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.HashSet;
import java.util.Set;

public class ChangesPlugin
extends AbstractReportPlugin {
    public Object[] getExtensions() {
        return new Object[]{new DefaultChangesRecorder(), new ChangesStatsProvider(), new LocalChangesBuildTabContribution(), new ChangesBuildTab(), new ChangesStatisticsTab(), new CategoryBuildOverview(){

            protected ReportCategory getCategory() {
                return ChangesPlugin.this.getReportCategory();
            }

            public boolean isApplicable() {
                if (!SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
                    return false;
                }
                return ChangesHelper.getChangeCount(Context.getBuild()) > 0L;
            }
        }, new RestResourceContribution(){

            public Set<Class<?>> getResourceClasses() {
                HashSet classes = new HashSet();
                classes.add(ChangesResource.class);
                return classes;
            }
        }, new ReportSummaryContribution(){

            protected ReportCategory getCategory() {
                return ChangesPlugin.this.getReportCategory();
            }

            public boolean isApplicable(Build build) {
                if (!SecurityHelper.hasPermission((Configuration)build.getConfiguration(), (String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
                    return false;
                }
                return ChangesHelper.getChangeCount(build) > 0L;
            }
        }, new DefaultCommentTransformer(), new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return LatestCommitsGadget.class;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return CommitStatsGadget.class;
            }
        }, new AggregationSupport(){

            public Class<? extends Aggregation> getAggregationClass() {
                return ChangesAggregator.class;
            }

            public void cleanupAggregations(Configuration configuration) {
                ReportCategory category = ChangesPlugin.this.getReportCategory();
                category.deleteAllReportSetsOfAggregation(configuration);
            }
        }, new CategoryAggregationOverview(){

            protected ReportCategory getCategory() {
                return ChangesPlugin.this.getReportCategory();
            }

            protected String getToTab() {
                return Tab.title2id((String)"");
            }
        }, new ReportGadgetProvider(ChangesAggregationOverviewGadget.class)};
    }

    protected Object[] getAggregationSupport() {
        return new Object[0];
    }

    public Class<?> getConfigurationSettingClass() {
        return GenericTransformerSetting.class;
    }

    protected Class<? extends Step> getPublishStepClass() {
        return null;
    }

    protected ReportCategory createCategory() {
        return new ChangesCategory();
    }

    public PluginCategory getCategory() {
        return PluginCategory.SYSTEM;
    }
}

