/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesCategory;
import com.pmease.quickbuild.plugin.report.changes.ChangesPlugin;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.AdditionalInfo;
import com.pmease.quickbuild.plugin.report.changes.rest.ChangesetMapper;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.MatchMode;

public class ChangesHelper {
    public static final String UNKNOWN_USER = "UNKNOWN";
    static final int DEFAULT_COUNT = 50;

    public static void changesToReport(List<BuildChangeset> changes, DataReport report) {
        if (changes.isEmpty()) {
            return;
        }
        ChangesCategory.ChangesReportType type = ChangesCategory.ChangesReportType.valueOf(report.getReportName().toUpperCase());
        switch (type) {
            case CHANGESETS: {
                ChangesHelper.changesToChangesetReport(changes, report);
                break;
            }
            case MODIFICATIONS: {
                ChangesHelper.changesToModificationsReport(changes, report);
                break;
            }
            case FILES: {
                break;
            }
            case COMMITUSERS: {
                break;
            }
        }
    }

    public static void changesToModificationsReport(List<BuildChangeset> changes, DataReport report) {
        for (BuildChangeset change : changes) {
            String user = change.getUser();
            if (StringUtils.isEmpty((String)user)) {
                user = UNKNOWN_USER;
            }
            for (Modification modification : change.getModifications()) {
                DataRow row = report.addRow();
                row.setValue("changeId", (Object)change.getId());
                row.setValue("repository", (Object)change.getRepositoryName());
                row.setValue("comment", (Object)change.getComment());
                row.setValue("committer", (Object)user);
                row.setValue("commitDate", DataTypes.TIME.typeCast((Object)change.getDate()));
                ChangesHelper.modificationToRow(modification, row);
            }
        }
    }

    private static void modificationToRow(Modification modification, DataRow row) {
        Modification.Action action;
        row.setValue("fileName", (Object)modification.getPath());
        row.setValue("edition", (Object)modification.getEdition());
        row.setValue("previousEdition", (Object)modification.getPreviousEdition());
        Modification.PathType pathType = modification.getPathType();
        if (pathType != null) {
            row.setValue("pathType", (Object)pathType.name());
        }
        if ((action = modification.getAction()) == null) {
            action = Modification.Action.MODIFY;
        }
        row.setValue("action", (Object)action.name().toUpperCase());
    }

    public static void changesToChangesetReport(List<BuildChangeset> changes, DataReport report) {
        for (BuildChangeset change : changes) {
            DataRow row = report.addRow();
            ChangesHelper.changesetToDataRow(change, row);
        }
    }

    public static void changesetToDataRow(BuildChangeset change, DataRow row) {
        row.setValue("changeId", (Object)change.getId());
        row.setValue("repository", (Object)change.getRepositoryName());
        if (change.getDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(change.getDate());
            row.setValue("commitDate", (Object)cal);
        }
        row.setValue("comment", (Object)change.getComment());
        String user = change.getUser();
        if (StringUtils.isEmpty((String)user)) {
            user = UNKNOWN_USER;
        }
        row.setValue("committer", (Object)user);
        Changeset c = change.getChangeset();
        if (c instanceof AdditionalInfo) {
            row.setValue("additional", (Object)((AdditionalInfo)c).asString());
        }
        int added = 0;
        int modified = 0;
        int deleted = 0;
        for (Modification modification : change.getModifications()) {
            Modification.Action action = modification.getAction();
            if (action == null) {
                action = Modification.Action.MODIFY;
            }
            switch (action) {
                case ADD: {
                    ++added;
                    break;
                }
                case MODIFY: {
                    ++modified;
                    break;
                }
                case DELETE: {
                    ++deleted;
                }
            }
        }
        row.setValue("added", (Object)added);
        row.setValue("modified", (Object)modified++);
        row.setValue("deleted", (Object)deleted++);
        row.setValue("modifications", (Object)change.getModifications().size());
    }

    public static List<RawChangeset> getBuildChangesets(Long buildId) {
        Build b = (Build)((BuildManager)Quickbuild.getInstance(BuildManager.class)).get(buildId);
        return ChangesHelper.getBuildChangesets(b);
    }

    public static List<RawChangeset> getBuildChangesets(Build build) {
        return ChangesHelper.getBuildChangesets((Build)Preconditions.checkNotNull((Object)build), Collections.<Filter>emptyList(), 0, -1, true);
    }

    private static SqlBuilder queryForModifications(List<Filter> filters, int offset, int count, boolean asc) {
        SqlBuilder query = SqlBuilder.query();
        query.select(new String[]{"changesets.buildId, changesets.repository, changesets.changeId, changesets.committer, changesets.userId, changesets.comment, changesets.commitDate, changesets.additional,modifications.fileName, modifications.action, modifications.edition, modifications.previousEdition, modifications.pathType"});
        query.from(new String[]{"changesets"}).leftJoin("modifications");
        query.on("modifications.changeId = changesets.changeId and modifications.repository = changesets.repository and modifications.buildId = changesets.buildId");
        query.where(filters);
        query.orderby(new Order[]{new Order("changesets.commitDate", asc)});
        query.offset(offset);
        if (count == 0) {
            query.limit(50);
        } else if (count > 0) {
            query.limit(count);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawChangeset> getChangesets(Configuration c, List<Filter> filters, int offset, int limit, boolean asc) {
        ReportCategory category = ReportHelper.getCategory(ChangesPlugin.class);
        File dbDir = category.getReportDirOfStats(c, "DEFAULT");
        if (!dbDir.exists()) {
            return Collections.emptyList();
        }
        SqlBuilder query = ChangesHelper.queryForModifications(filters, offset, limit, asc);
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "ChangesHelper::getChangesets");
            List list = (List)db.query(query, (ResultSetHandler)new ChangesetMapper(c.findRepositories()));
            return list;
        }
        finally {
            db.close();
        }
    }

    public static List<RawChangeset> getChangesets(Configuration c, Long fromBuild, Long toBuild, int offset, int limit, boolean asc) {
        ArrayList filters = Lists.newArrayList();
        if (fromBuild != null) {
            filters.add(Restrictions.ge((String)"changesets.buildId", (Object)fromBuild));
        }
        if (toBuild != null) {
            filters.add(Restrictions.le((String)"changesets.buildId", (Object)toBuild));
        }
        return ChangesHelper.getChangesets(c, filters, offset, limit, asc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawChangeset> getBuildChangesets(Build build, List<Filter> filters, int offset, int limit, boolean asc) {
        ReportCategory category = ReportHelper.getCategory(ChangesPlugin.class);
        File dbDir = category.getReportDirOfBuild(build, "DEFAULT");
        if (!dbDir.exists()) {
            return Collections.emptyList();
        }
        SqlBuilder query = ChangesHelper.queryForModifications(filters, offset, limit, asc);
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "ChangesHelper::getChangesets");
            List list = (List)db.query(query, (ResultSetHandler)new ChangesetMapper(build.getConfiguration().findRepositories()));
            return list;
        }
        finally {
            db.close();
        }
    }

    public static List<String> getCommitters(Build build, String path, boolean exactly) {
        return ChangesHelper.getCommitters(build, null, path, exactly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCommitters(Build build, String repository, String path, boolean exactly) {
        ChangesCategory category = (ChangesCategory)ReportHelper.getCategory(ChangesPlugin.class);
        File dbDir = category.getChangesDirOfBuild(build);
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "ChangesHelper::getCommitters");
            SqlBuilder query = SqlBuilder.query().select(new String[]{"committer"}).from(new String[]{"modifications"}).where(new Filter[]{Strings.isNullOrEmpty((String)repository) ? null : Restrictions.eq((String)"repository", (Object)repository), Restrictions.like((String)"fileName", (String)path, (MatchMode)(exactly ? MatchMode.EXACT : MatchMode.ANYWHERE))});
            List list = db.queryForArrayList(query);
            LinkedHashSet users = Sets.newLinkedHashSet();
            for (Object[] each : list) {
                String user = (String)each[0];
                if (Strings.isNullOrEmpty((String)user)) continue;
                users.add(user);
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)users);
            return arrayList;
        }
        finally {
            db.close();
        }
    }

    public static long getChangeCount(Build build) {
        ChangesCategory category = (ChangesCategory)ReportHelper.getCategory(ChangesPlugin.class);
        File dir = category.getChangesDirOfBuild(build);
        return category.getRowsCount(dir, "changesets");
    }

    public static Build getComparisonBuild() {
        Build contextBuild = Context.getBuild();
        if (contextBuild == null) {
            return null;
        }
        Pair comparingBuildId = SessionData.get().getComparisonBuild();
        if (comparingBuildId == null) {
            return null;
        }
        if ((Long)comparingBuildId.getFirst() >= Context.getBuild().getId()) {
            SessionData.get().setComparisonBuild(null);
            return null;
        }
        return (Build)((BuildManager)Quickbuild.getInstance(BuildManager.class)).get((Long)comparingBuildId.getFirst());
    }

    public static boolean hasComparingBuild() {
        return ChangesHelper.getComparisonBuild() != null;
    }

    public static boolean canHyperlink(Modification m) {
        if (m == null) {
            return false;
        }
        return SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name()) && !StringUtils.isEmpty((String)m.getPath()) && !StringUtils.isEmpty((String)m.getEdition()) && m.getPathType() != Modification.PathType.BINARY && m.getPathType() != Modification.PathType.DIR;
    }

    public static boolean canViewSource(Modification m) {
        if (!ChangesHelper.canHyperlink(m)) {
            return false;
        }
        return m.getAction() != Modification.Action.DELETE;
    }

    public static boolean canDiffSource(Modification m) {
        if (!ChangesHelper.canHyperlink(m)) {
            return false;
        }
        return m.getAction() != Modification.Action.ADD && m.getAction() != Modification.Action.DELETE && !StringUtils.isEmpty((String)m.getPreviousEdition());
    }

    public static String getViewSourceUrl(Long buildId, String repository, Modification modification) {
        return SourceViewPage.url4Edition((Long)buildId, (String)repository, (String)modification.getPath(), (String)modification.getEdition());
    }

    public static String getDiffSourceUrl(Long buildId, String repository, Modification modification) {
        return SourceDiffPage.url4Edition((Long)buildId, (String)modification.getPath(), (String)repository, (String)modification.getEdition(), (String)modification.getPreviousEdition());
    }
}

