/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.changes;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.migration.ChangesMigrator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.dom4j.Element;

public class ChangesCategory
extends ReportCategory {
    private static final long serialVersionUID = 1L;

    public ChangesCategory() {
        this.initFromStream(ChangesCategory.class, "setting.xml");
    }

    public boolean hasUnProcessedReport() {
        return false;
    }

    public DataReport loadFromSCM(Build from, Build to, ReportDataSource rds) {
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Load changes from SCM.");
        }
        List changes = from == null ? to.getChanges() : to.getChangesSince(from);
        DataReport report = this.createReport(rds.getFrom());
        ChangesHelper.changesToReport(changes, report);
        if (ChangesReportType.MODIFICATIONS.getMetaName().equalsIgnoreCase(rds.getFrom())) {
            report.sortRows("commitDate", false);
        }
        return report;
    }

    public void fromXML(Element node) {
        super.fromXML(node);
    }

    public File getChangesDirOfStats(Configuration configuration) {
        return this.getReportDirOfStats(configuration, "DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCategoryDirOfBuild(Build build) {
        File categoryDir = new File(build.getPublishDir(), "reports/" + this.getId());
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            if (!categoryDir.exists() && build.getStatus() == Build.Status.RUNNING) {
                File file = categoryDir;
                return file;
            }
            MigrationContext context = new MigrationContext();
            context.setBuild(build);
            context.setDir(categoryDir);
            context.setCategory((ReportCategory)this);
            this.upgrade(categoryDir, context);
            File file = categoryDir;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    public File getChangesDirOfBuild(Build build) {
        return this.getReportDirOfBuild(build, "DEFAULT");
    }

    public Class<? extends ReportCategoryMigrator> getMigratorClass() {
        return ChangesMigrator.class;
    }

    public String[] getReportSetsOfBuild(Build build) {
        super.getReportSetsOfBuild(build);
        return new String[]{"DEFAULT"};
    }

    public String[] getReportSetsOfStats(Configuration configuration) {
        super.getReportSetsOfStats(configuration);
        return new String[]{"DEFAULT"};
    }

    public static enum ChangesReportType {
        CHANGESETS("changesets"),
        FILES("files"),
        MODIFICATIONS("modifications"),
        COMMITUSERS("commitusers");

        private final String metaName;

        private ChangesReportType(String metaName) {
            this.metaName = metaName;
        }

        public String getMetaName() {
            return this.metaName;
        }
    }
}

