/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.nant;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.builder.nant.NAntSetting;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="NAnt", category={"Build"}, description="Configure a NAnt based build step here. By default, QuickBuild executes \"nant.exe\" to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the NAnt plugin through the plugin management page.")
@ScriptApi(value="This step calls NAnt to build projects.")
public class NAntBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String workingPath;
    private String buildScriptPath;
    private String buildTargets;
    private List<Property> buildProperties = new ArrayList<Property>();
    private String extraNAntOptions;
    private List<Property> environments = new ArrayList<Property>();
    private int returnCode;

    @Editable(order=1100, name="NAnt Build File", description="Specify the path to NAnt build file. A non-absolute path is considered to be relative to the workspace.")
    @NotEmpty
    @ScriptApi(value="Get NAnt build file path.")
    @Scriptable
    public String getBuildScriptPath() {
        return this.buildScriptPath;
    }

    public void setBuildScriptPath(String buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
    }

    @Editable(order=1200, description="Specify the targets to build. Use space to separate different targets (target name containing spaces should be quoted in order not to be interpreted as multiple targets)")
    @ScriptApi(value="Get build targets. Null if not specified.")
    @Scriptable
    public String getBuildTargets() {
        return this.buildTargets;
    }

    public void setBuildTargets(String buildTargets) {
        this.buildTargets = buildTargets;
    }

    @Editable(order=1300, description="Define build properties here to pass into the build script. For example, you may pass version of current build as property <i>buildVersion</i> by specifying property name as <i>buildVersion</i> and property value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Properties with blank value will be ignored.")
    @ScriptApi(value="Get list of properties passed to NAnt build process.")
    public List<Property> getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(List<Property> buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Editable(order=1400, name="Working Directory", description="Optionally specify working directory for NAnt command. A non-absolute path is considered to be relative to the directory containing the build script specified above. If not specified, the directory containing the build script will be used as working directory.")
    @ScriptApi(value="Get working directory path of NAnt command. Null if the directory containing the build script is used as working directory.")
    @Scriptable
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @Editable(order=1500, description="Optionally specify extra NAnt options. Please note that you should not specify following options as they'll be added by Quickbuild based on other settings:<br><b>-f, -buildfile, -file</b>")
    @ScriptApi(value="Get extra NAnt options. Null if not specified.")
    @Scriptable
    @Advanced
    public String getExtraNAntOptions() {
        return this.extraNAntOptions;
    }

    public void setExtraNAntOptions(String extraNAntOptions) {
        this.extraNAntOptions = extraNAntOptions;
    }

    @Editable(name="Environment Variables", order=1600, description="Specify environment variables for NAnt execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @ScriptApi(value="Get return code of NAnt command.")
    public int getReturnCode() {
        return this.returnCode;
    }

    private Commandline getBuildCmd() {
        Commandline cmdline = new Commandline();
        cmdline.setExecutable(this.getNAntExecutable());
        if (StringUtils.isNotBlank((String)this.getExtraNAntOptions())) {
            cmdline.createArgument().setLine(this.getExtraNAntOptions());
        }
        for (Property property : this.getBuildProperties()) {
            if (!StringUtils.isNotBlank((String)property.getValue())) continue;
            cmdline.createArgument().setValue("-D:" + property.getName() + "=" + property.getValue());
        }
        String cmdLineDescription = cmdline.describe();
        if (!(cmdLineDescription.matches(".*\\s(-q|-quiet)($|\\s.*)") || cmdLineDescription.matches(".*\\s(-v|-verbose)($|\\s.*)") || cmdLineDescription.matches(".*\\s-debug($|\\s.*)"))) {
            if (!Context.getLogger().isInfoEnabled()) {
                cmdline.createArgument().setValue("-q");
            } else if (Context.getLogger().isDebugEnabled()) {
                cmdline.createArgument().setValue("-v");
            }
        }
        File buildScriptFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getBuildScriptPath());
        cmdline.createArgument().setValue("-buildfile:" + buildScriptFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.getBuildTargets())) {
            cmdline.createArgument().setLine(this.getBuildTargets());
        }
        return cmdline;
    }

    private File getWorkingDir() {
        File buildScriptFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getBuildScriptPath());
        return FileUtils.resolvePath((File)buildScriptFile.getParentFile(), (String)this.getWorkingPath());
    }

    private String getNAntExecutable() {
        String nantExe = ((NAntSetting)this.getPlugin().getSetting(true)).getNantExecutablePath();
        if (nantExe == null) {
            nantExe = "nant.exe";
        }
        return nantExe;
    }

    public void run() {
        Commandline cmdline = this.getBuildCmd();
        Environment env = new Environment();
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        final boolean[] containsBuildSucceededMsg = new boolean[]{false};
        this.returnCode = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                if (line.contains("BUILD SUCCEEDED")) {
                    containsBuildSucceededMsg[0] = true;
                }
            }
        }, new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().warn(line);
                if (line.contains("BUILD SUCCEEDED")) {
                    containsBuildSucceededMsg[0] = true;
                }
            }
        }).getReturnCode();
        if (!containsBuildSucceededMsg[0] || this.returnCode != 0) {
            throw new QuickbuildException("NAnt build failed.");
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("nantWorkingPath");
        if (element != null) {
            element.detach();
            dom.getRootElement().addElement("workingPath").setText(element.getTextTrim());
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        root.element("commandSuccessCondition").detach();
        root.element("environmentVariables").setName("environments");
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }
}

