/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mbunit.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.mbunit.renderer.TestDetailsColumn;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public TestDetailsColumnPanel(String id, TestDetailsColumn column, IModel<ItemContext> model) {
        super(id);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        this.add(new Component[]{new Label("runName", row.getValueAsString("runName"))});
        String status = row.getValueAsString("status");
        status = ReportUtils.firstOf((String)status, (int)4);
        Label statusLabel = new Label("status", status);
        statusLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{statusLabel});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        String committers = row.getValueAsString("committers");
        this.add(new Component[]{new Label("committers", committers).setVisible(!Strings.isNullOrEmpty((String)committers))});
        this.add(new Component[]{column.namespaceLinkItem.createComponent("namespaceLink", model)});
        this.add(new Component[]{column.fixtureLinkItem.createComponent("fixtureLink", model)});
        List warnings = (List)row.getValue("warnings");
        if (warnings.isEmpty()) {
            this.add(new Component[]{new WebMarkupContainer("warnings").setVisible(false)});
        } else {
            StringBuffer sb = new StringBuffer();
            for (String each : warnings) {
                if (Strings.isNullOrEmpty((String)each)) continue;
                sb.append("<div>").append(each).append("</div>");
            }
            this.add(new Component[]{new Label("warnings", sb.toString()).setEscapeModelStrings(false)});
        }
        String str = row.getValueAsString("exceptionType");
        this.add(new Component[]{new Label("exceptionType", str).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("exceptionMessage");
        this.add(new Component[]{new Label("exceptionMessage", "<pre>" + StringEscapeUtils.escapeHtml((String)str) + "</pre>").setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("exceptionSource");
        this.add(new Component[]{new Label("exceptionSource", str).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("exceptionStack");
        this.add(new Component[]{new Label("exceptionStack", "<pre>" + StringEscapeUtils.escapeHtml((String)str) + "</pre>").setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)str))});
    }
}

