/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mbunit;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.mbunit.MBUnitPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="MBUnit Report", description="Publish MBUnit reports")
@ScriptApi(value="This step publishes the original MBUnit XML files.")
public class MBUnitPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int failures;
    @XStreamOmitField
    private int skips;
    @XStreamOmitField
    private int ignores;
    @XStreamOmitField
    private int runs;
    @XStreamOmitField
    private int asserts;

    public MBUnitPublisher() {
        this.setStepFailureCondition("current.failures > 0");
        this.setStepFailureMessage("Found failed tests in MBUnit report.");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(MBUnitPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "MBUnitPublisher::saveStatsReport");
            Map stats = category.getDefaultStats(db, "namespaces", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(stats);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            this.runs = row.getInt("runs");
            this.failures = row.getInt("failures");
            this.ignores = row.getInt("ignores");
            this.skips = row.getInt("skips");
            double successRate = MathUtils.divide((int)(this.runs - this.failures), (int)this.runs);
            row.setValue("success_rate", (Object)successRate);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_test", (String)reportsetName)).put((Object)"failedTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"failed_tests", (String)reportsetName)).build();
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"has failed tests", "current.failures > 0", "I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Total failed runs in MBUnit report.")
    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    @ScriptApi(value="Total skipped runs in MBUnit report.")
    public int getSkips() {
        return this.skips;
    }

    public void setSkips(int skips) {
        this.skips = skips;
    }

    @ScriptApi(value="Total ignored runs in MBUnit report.")
    public int getIgnores() {
        return this.ignores;
    }

    public void setIgnores(int ignores) {
        this.ignores = ignores;
    }

    @ScriptApi(value="Total runs in MBUnit report.")
    public int getRuns() {
        return this.runs;
    }

    public void setRuns(int runs) {
        this.runs = runs;
    }

    @ScriptApi(value="Total asserts in MBUnit report.")
    public int getAsserts() {
        return this.asserts;
    }

    public void setAsserts(int asserts) {
        this.asserts = asserts;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "current.failures > 0");
        dom.setValue("stepFailureMessage", "Found failed tests in MBUnit report.");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"failures");
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"skips");
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"ignores");
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"runs");
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"asserts");
        MBUnitPublisher.removeElement((VersionedDocument)dom, (String)"duration");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return MBUnitChecksum.class;
    }

    public static class MBUnitChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(MBUnitPlugin.class);
        }
    }
}

