/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mbunit;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.ArrayList;
import java.util.List;

public class LatestColumnsRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;
    private static final String[] columns = new String[]{"latestBuilds".toUpperCase(), "latestStatuses".toUpperCase(), "latestDuration".toUpperCase(), "averageDuration".toUpperCase()};

    public LatestColumnsRule(ReportCategory category) {
        super(category);
    }

    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        List latestBuilds = (List)destRow.getValue("latestBuilds");
        List latestStatuses = (List)destRow.getValue("latestStatuses");
        List latestDurations = (List)destRow.getValue("latestDurations");
        Long buildId = Context.getBuild().getId();
        int index = -1;
        for (int i = 0; i < latestBuilds.size(); ++i) {
            Long b = (Long)latestBuilds.get(i);
            if (!Objects.equal((Object)buildId, (Object)b)) continue;
            index = i;
            break;
        }
        String status = sourceRow.getValueAsString("status");
        Long duration = (Long)sourceRow.getValue("duration");
        if (index == -1) {
            latestBuilds = ReportUtils.limitAddingValue((List)latestBuilds, (Object)buildId);
            latestStatuses = ReportUtils.limitAddingValue((List)latestStatuses, (Object)status);
            latestDurations = ReportUtils.limitAddingValue((List)latestDurations, (Object)duration);
            String currentStatus = status;
        } else {
            String destStatus = (String)latestStatuses.get(index);
            Long destDuration = (Long)latestDurations.get(index);
            String currentStatus = LatestColumnsRule.evaluateStatus(destStatus, status);
            latestStatuses.add(index, currentStatus);
            latestDurations.add(index, destDuration + duration);
        }
        destRow.setValue("latestBuilds", (Object)latestBuilds);
        destRow.setValue("latestStatuses", (Object)latestStatuses);
        destRow.setValue("latestDurations", (Object)latestDurations);
        destRow.setValue("averageDuration", (Object)ReportUtils.average(new ArrayList(latestDurations)));
    }

    static String evaluateStatus(String dest, String source) {
        Status sDest = Status.SKIP;
        Status sSource = Status.SKIP;
        if (!Strings.isNullOrEmpty((String)dest)) {
            sDest = Status.valueOf(dest);
        }
        if (!Strings.isNullOrEmpty((String)source)) {
            sSource = Status.valueOf(source);
        }
        if (sSource.ordinal() - sDest.ordinal() > 0) {
            return source;
        }
        return dest;
    }

    protected String[] forColumns() {
        return columns;
    }

    private static enum Status {
        SKIP,
        PASS,
        FAILURE,
        ERROR;

    }
}

