/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.mstest.renderer.TestDetailsColumn;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public TestDetailsColumnPanel(String id, TestDetailsColumn column, IModel<ItemContext> model) {
        super(id, model);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        WebMarkupContainer anchor = new WebMarkupContainer("anchor");
        anchor.add(new Behavior[]{new AttributeModifier("name", (IModel)Model.of((Serializable)((Object)row.getValueAsString("id"))))});
        anchor.add(new Component[]{new Label("testName", row.getValueAsString("testName")).setRenderBodyOnly(true)});
        this.add(new Component[]{anchor});
        int totalRuns = row.getInt("totalRuns");
        this.add(new Component[]{new Label("totalRuns", String.valueOf(totalRuns)).setVisible(totalRuns > 1)});
        this.add(new Component[]{new Label("passedRuns", row.getValueAsString("passedRuns"))});
        this.add(new Component[]{new Label("failedRuns", row.getValueAsString("failedRuns"))});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        this.add(new Component[]{new Label("testList", row.getValueAsString("testList")).setRenderBodyOnly(true)});
        this.add(new Component[]{new Label("duration", row.getValueAsString("duration")).setEscapeModelStrings(true)});
        this.add(new Component[]{column.nsLinkItem.createComponent("namespaceLink", model)});
        this.add(new Component[]{column.classLinkItem.createComponent("classLink", model)});
        String status = row.getValueAsString("status");
        Label statusLabel = new Label("status", status);
        statusLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{statusLabel});
        String str = this.formatStacktrace(row);
        if (Strings.isNullOrEmpty((String)str)) {
            this.add(new Component[]{new WebMarkupContainer("message").setVisible(false)});
        } else {
            this.add(new Component[]{new Label("message", str).setEscapeModelStrings(false)});
        }
    }

    private String formatStacktrace(DataRow row) {
        List errorMessages = (List)row.getValue("errorMessage");
        List stacktraces = (List)row.getValue("stacktrace");
        StringBuffer sb = new StringBuffer();
        int size = Math.min(errorMessages.size(), 5);
        for (int i = 0; i < size; ++i) {
            String msg = (String)errorMessages.get(i);
            if (Strings.isNullOrEmpty((String)msg)) {
                msg = "";
            }
            String stack = i < stacktraces.size() ? (String)stacktraces.get(i) : "";
            if (Strings.isNullOrEmpty((String)msg) && Strings.isNullOrEmpty((String)stack)) continue;
            if (errorMessages.size() > 1) {
                sb.append("<li>");
            }
            sb.append("<pre>" + StringEscapeUtils.escapeHtml((String)msg) + "</pre>");
            sb.append("<pre>" + StringEscapeUtils.escapeHtml((String)stack) + "</pre>");
            if (errorMessages.size() <= 1) continue;
            sb.append("</li>");
        }
        String str = sb.toString();
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (errorMessages.size() > 1) {
            str = "<ol>" + str + "</ol>";
        }
        if (errorMessages.size() > 5) {
            str = str + "<p>...</p>";
        }
        return str;
    }
}

