/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest.migration;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.mstest.TestStatus;
import java.io.File;
import java.util.List;

public class Tests3To4 {
    public static void execute(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport dest = category.createReport("tests");
        ReportMetaData meta = new ReportMetaData();
        meta.initFromStream(Tests3To4.class, "tests-3.1.xml");
        DataReport src = new DataReport(meta);
        File file = new File(db.getDbDir(), src.getOutputName());
        src.loadFromXML(file);
        DataColumn[] compareColumns = dest.getMeta().getPrimaryColumns();
        for (DataRow each : src.getRows()) {
            DataRow found = dest.findRow(each, compareColumns);
            if (found == null) {
                found = dest.addRow();
                found.setValue("testId", each.getNullableValue("testId"));
                found.setValue("nsName", each.getNullableValue("nsName"));
                found.setValue("className", each.getNullableValue("className"));
                found.setValue("testName", each.getNullableValue("testName"));
                found.setValue("testList", each.getNullableValue("testList"));
                found.setValue("committers", each.getNullableValue("committers"));
            }
            found.setValue("diffStatus", (Object)each.getString("diffStatus"));
            long duration = found.getLong("duration") + each.getLong("duration");
            found.setValue("duration", (Object)duration);
            String status = (String)each.getNullableValue("status");
            if (Strings.isNullOrEmpty((String)status)) {
                status = "PASS";
            }
            if ("PASSED".equalsIgnoreCase(status)) {
                status = "PASS";
                found.setValue("passedRuns", (Object)(found.getInt("passedRuns") + 1));
            } else if ("FAILED".equalsIgnoreCase(status)) {
                status = "FAIL";
                found.setValue("failedRuns", (Object)(found.getInt("failedRuns") + 1));
            } else if ("SKIPPED".equalsIgnoreCase(status)) {
                status = "SKIP";
                found.setValue("skippedRuns", (Object)(found.getInt("skippedRuns") + 1));
            }
            found.setValue("totalRuns", (Object)(found.getInt("totalRuns") + 1));
            TestStatus ts = TestStatus.valueOf(status);
            String current = found.getString("status");
            TestStatus cts = Strings.isNullOrEmpty((String)current) ? ts : TestStatus.valueOf(current);
            switch (ts) {
                case FAIL: {
                    cts = ts;
                    break;
                }
                case PASS: {
                    if (cts != TestStatus.SKIP) break;
                    cts = ts;
                    break;
                }
            }
            found.setValue("status", (Object)cts.name());
            List list = (List)found.getValue("errorMessage");
            String msg = each.getString("errorMessage");
            if (!Strings.isNullOrEmpty((String)msg)) {
                list.add(msg);
                found.setValue("errorMessage", (Object)list);
            }
            list = (List)found.getValue("stacktrace");
            String stacktrace = each.getString("stacktrace");
            if (Strings.isNullOrEmpty((String)stacktrace)) continue;
            list.add(stacktrace);
            found.setValue("stacktrace", (Object)list);
        }
        category.saveReport(db, dest);
    }
}

