/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest.migration;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.mstest.migration.TestTrends3To4;
import com.pmease.quickbuild.plugin.report.mstest.migration.Tests3To4;
import java.io.File;
import java.util.Map;
import java.util.Stack;

public class MSTestMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void report3To4(ReportMetaData meta, MigrationContext context, CategoryDb db) {
        if ("tests".equalsIgnoreCase(meta.getReportName())) {
            Tests3To4.execute(context, db);
        } else if ("tests_trends".equalsIgnoreCase(meta.getReportName())) {
            TestTrends3To4.execute(context, db);
        } else if (meta.hasColumn("skips")) {
            DataReport report = new DataReport(meta);
            File file = new File(db.getDbDir(), report.getOutputName());
            if (!file.exists()) {
                return;
            }
            ReportMetaData previous = meta.newInstance();
            previous.renameColumn("skips", "skipped");
            DataReport previousReport = new DataReport(previous);
            previousReport.loadFromXML(file);
            previous.renameColumn("skipped", "skips");
            db.saveReport(previousReport);
        } else {
            super.report3To4(meta, context, db);
        }
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        Map stats = category.getDefaultStats(db, "namespaces", new Filter[0]);
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getBuild().getId());
        int tests = row.getInt("tests");
        int failures = row.getInt("failures");
        double success_rate = MathUtils.divide((int)(tests - failures), (int)tests);
        row.setValue("success_rate", (Object)success_rate);
        category.saveReport(db, statsReport);
    }
}

