/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.mstest.MSTestPlugin;

@Editable(name="MSTest Report")
public class MSTestAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(MSTestPlugin.class);
    }

    static void setSuccessRate(DataRow destRow) {
        int tests = destRow.getInt("tests");
        int failures = destRow.getInt("failures");
        double success_rate = MathUtils.divide((int)(tests - failures), (int)tests);
        destRow.setValue("success_rate", (Object)success_rate);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        MSTestAggregator.setSuccessRate(destRow);
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        MSTestAggregator.setSuccessRate(destRow);
    }
}

