/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class TrxFileProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;
    static PeriodFormatter durationFormatter = new PeriodFormatterBuilder().printZeroNever().appendDays().appendSuffix(".").printZeroAlways().appendHours().minimumPrintedDigits(2).appendSeparator(":").printZeroAlways().appendMinutes().minimumPrintedDigits(2).appendSeparator(":").printZeroAlways().appendSeconds().minimumPrintedDigits(2).toFormatter();

    public TrxFileProcessor(ReportCategory category) {
        super(category);
    }

    protected void processCurrentElement() {
        GeneratorContext context = this.getContext();
        Element element = context.getCurrentElement();
        if (element == null) {
            return;
        }
        Document doc = element.getDocument();
        DataRow currentRow = context.getDestRow();
        String testId = element.attributeValue("testId");
        Element node = (Element)doc.selectSingleNode("//UnitTest[@id='" + testId + "']");
        if (node == null) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)new DocumentException("Unable to find the specified UnitTest node with id: " + testId));
        }
        currentRow.setValue("testName", (Object)node.valueOf("./TestMethod/@name"));
        String className = node.valueOf("./TestMethod/@className");
        String nsName = "";
        String[] tokens = StringUtils.split((String)className, (char)',');
        if (tokens.length > 1) {
            className = tokens[0];
            tokens = ReportUtils.splitClassName((String)className);
            className = tokens[0];
            if (tokens.length > 1) {
                nsName = tokens[1];
            }
        }
        currentRow.setValue("nsName", (Object)className);
        currentRow.setValue("className", (Object)nsName);
        String str = element.attributeValue("duration");
        long duration = TrxFileProcessor.parseDuration(str);
        currentRow.setValue("duration", (Object)duration);
        currentRow.setValue("errorMessage", (Object)Lists.newArrayList((Object[])new String[]{element.valueOf("./Output//Message")}));
        currentRow.setValue("stacktrace", (Object)Lists.newArrayList((Object[])new String[]{element.valueOf("./Output//StackTrace")}));
        String outcome = element.attributeValue("outcome");
        String status = this.outcomeToStatus(outcome);
        currentRow.setValue("status", (Object)status);
        String testListId = element.attributeValue("testListId");
        node = (Element)doc.selectSingleNode("//TestList[@id='" + testListId + "']");
        if (node != null) {
            currentRow.setValue("testList", (Object)node.attributeValue("name"));
        }
        currentRow.setValue("totalRuns", (Object)1);
        if ("PASS".equals(status)) {
            currentRow.setValue("passedRuns", (Object)1);
        } else if ("FAIL".equals(status)) {
            currentRow.setValue("failedRuns", (Object)1);
        } else {
            currentRow.setValue("skippedRuns", (Object)1);
        }
    }

    private static long parseDuration(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return 0L;
        }
        int posDot = str.lastIndexOf(46);
        int posCol = str.indexOf(58);
        long mils = 0L;
        if (posDot > posCol) {
            Double d = (Double)DataTypes.DOUBLE.fromString(str.substring(posDot), null, Locale.US);
            mils = Math.round(d * 1000.0);
            str = str.substring(0, posDot);
        }
        long duration = durationFormatter.withLocale(Locale.US).parsePeriod(str).toStandardDuration().getMillis();
        return duration + mils;
    }

    private String outcomeToStatus(String outcome) {
        if (StringUtils.isEmpty((String)outcome)) {
            return "SKIP";
        }
        if (outcome.equalsIgnoreCase("PASSED")) {
            return "PASS";
        }
        if (outcome.equalsIgnoreCase("FAILED") || outcome.equalsIgnoreCase("TIMEOUT")) {
            return "FAIL";
        }
        return "SKIP";
    }

    public static void main(String[] args) {
        String str = "1.01:00:01";
        System.out.println(DataTypes.DURATION.asString((Object)TrxFileProcessor.parseDuration(str)));
        str = "00:00:00.5971063";
        System.out.println(DataTypes.DURATION.asString((Object)TrxFileProcessor.parseDuration(str), "WORD"));
    }
}

