/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.mstest.TestStatus;
import java.util.List;

public class TestDuplicateRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public TestDuplicateRule(ReportCategory category) {
        super(category);
    }

    public void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        List sourceMessages = (List)sourceRow.getValue("errorMessage");
        List destMessages = (List)destRow.getValue("errorMessage");
        destMessages.addAll(sourceMessages);
        destRow.setValue("errorMessage", (Object)destMessages);
        List sourceStacktrace = (List)sourceRow.getValue("stacktrace");
        List destStacktrace = (List)destRow.getValue("stacktrace");
        destStacktrace.addAll(sourceStacktrace);
        destRow.setValue("stacktrace", (Object)destStacktrace);
        TestStatus destStatus = TestStatus.valueOf(destRow.getValueAsString("status").toUpperCase());
        TestStatus sourceStatus = TestStatus.valueOf(sourceRow.getValueAsString("status").toUpperCase());
        switch (sourceStatus) {
            case FAIL: {
                destStatus = sourceStatus;
                break;
            }
            case PASS: {
                if (destStatus != TestStatus.SKIP) break;
                destStatus = sourceStatus;
                break;
            }
        }
        destRow.setValue("status", (Object)destStatus.name());
        int totalRuns = destRow.getInt("totalRuns") + 1;
        destRow.setValue("totalRuns", (Object)totalRuns);
        switch (sourceStatus) {
            case PASS: {
                destRow.setValue("passedRuns", (Object)(destRow.getInt("passedRuns") + 1));
                break;
            }
            case FAIL: {
                destRow.setValue("failedRuns", (Object)(destRow.getInt("failedRuns") + 1));
                break;
            }
            default: {
                destRow.setValue("skippedRuns", (Object)(destRow.getInt("skippedRuns") + 1));
            }
        }
    }

    protected String[] forColumns() {
        return new String[]{"status", "errorMessage", "stacktrace", "totalRuns", "passedRuns", "failedRuns", "skippedRuns"};
    }
}

