/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.mstest;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.mstest.MSTestPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="MSTest Report", description="Publish MSTest reports")
@ScriptApi(value="This step publishes the original MSTest report files.")
public class MSTestPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int tests;
    @XStreamOmitField
    private int failures;
    @XStreamOmitField
    private int skips;

    public MSTestPublisher() {
        this.setStepFailureCondition("current.failures > 0");
        this.setStepFailureMessage("Found failed tests in MSTest report.");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(MSTestPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "MSTestPublisher::saveStatsReport");
            Map stats = category.getDefaultStats(db, "namespaces", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(stats);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            this.tests = row.getInt("tests");
            this.failures = row.getInt("failures");
            this.skips = row.getInt("skips");
            double successRate = MathUtils.divide((int)(this.tests - this.failures), (int)this.tests);
            row.setValue("success_rate", (Object)successRate);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected String getStatsReportName() {
        return "stats";
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_test", (String)reportsetName)).put((Object)"failedTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"failed_tests", (String)reportsetName)).build();
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"has failed tests", "current.failures > 0", "I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Total tests in MSTest report.")
    public int getTests() {
        return this.tests;
    }

    public void setTests(int tests) {
        this.tests = tests;
    }

    @ScriptApi(value="Total failures in MSTest report.")
    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    @ScriptApi(value="Total skipped tests in MSTest report.")
    public int getSkips() {
        return this.skips;
    }

    public void setSkips(int skips) {
        this.skips = skips;
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return MSTestChecksum.class;
    }

    public static class MSTestChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(MSTestPlugin.class);
        }
    }
}

