/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.bazaar.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrChangeset;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrModification;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.TooBigXMLLogException;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ChangeLogXMLConsumer
extends AbstractChangeLogConsumer {
    private final String excludeId;
    private List<Changeset> changesets = null;
    private static final DateTimeFormatter DATE_FMT = DateTimeFormat.forPattern((String)"EEE yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.US);

    public ChangeLogXMLConsumer() {
        this(null);
    }

    public ChangeLogXMLConsumer(String excludeId) {
        this(Log.LogLevel.DEBUG, excludeId);
    }

    public ChangeLogXMLConsumer(Log.LogLevel level, String excludeId) {
        super(level, "UTF-8");
        this.excludeId = excludeId;
    }

    @Override
    public List<Changeset> getChanges() {
        if (this.changesets == null) {
            this.changesets = this.parse(this.getContent());
            this.lines.clear();
        }
        return this.changesets;
    }

    public List<Changeset> parse(String xml) {
        if (xml.length() > 10000000) {
            throw new TooBigXMLLogException();
        }
        if (StringUtils.isEmpty((String)xml)) {
            return Collections.emptyList();
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            List logs = doc.getRootElement().elements("log");
            ArrayList<Changeset> changes = new ArrayList<Changeset>();
            for (Element log : logs) {
                List<Changeset> each = this.parseChangeset(log);
                changes.addAll(each);
            }
            return changes;
        }
        catch (DocumentException e) {
            throw new ScmException("Unable to parse bazaar log xml", (Throwable)e);
        }
    }

    private List<Changeset> parseChangeset(Element log) {
        int pos;
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        BzrChangeset c = new BzrChangeset();
        String revno = log.valueOf("./revno").trim();
        if (revno.equalsIgnoreCase(this.excludeId)) {
            return Collections.emptyList();
        }
        c.setRevno(log.valueOf("./revno").trim());
        c.setId(log.valueOf("./revisionid").trim());
        String timestamp = log.valueOf("./timestamp");
        if (c.getId().equals(this.excludeId)) {
            return Collections.emptyList();
        }
        c.setDate(DATE_FMT.parseDateTime(timestamp).toDate());
        c.setComment(log.elementText("message"));
        String user = log.valueOf("./committer");
        if (!StringUtils.isEmpty((String)user) && (pos = user.indexOf(" <")) > 0) {
            user = user.substring(0, pos);
        }
        c.setUser(user);
        List parents = log.selectNodes("./parents/parent");
        String previousEdition = parents.isEmpty() ? null : ((Element)parents.get(0)).getTextTrim();
        c.setModifications(this.parseModifications(log, c, previousEdition));
        changes.add(c);
        List elements = log.selectNodes("./merge/log");
        for (Element each : elements) {
            List<Changeset> mergedChanges = this.parseChangeset(each);
            changes.addAll(mergedChanges);
        }
        return changes;
    }

    private List<Modification> parseModifications(Element node, BzrChangeset c, String previousEdition) {
        Element renamed;
        Element removed;
        Element modified;
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        Element added = (Element)node.selectSingleNode("./affected-files/added");
        if (added != null) {
            List elements = added.elements();
            for (Element each : elements) {
                BzrModification m = ChangeLogXMLConsumer.parseModification(each);
                m.setAction(Modification.Action.ADD);
                m.setEdition(c.getId());
                m.setRevno(c.getRevno());
                m.setPreviousEdition(null);
                modifications.add(m);
            }
        }
        if ((modified = (Element)node.selectSingleNode("./affected-files/modified")) != null) {
            List elements = modified.elements();
            for (Element each : elements) {
                BzrModification m = ChangeLogXMLConsumer.parseModification(each);
                m.setAction(Modification.Action.MODIFY);
                m.setEdition(c.getId());
                m.setRevno(c.getRevno());
                m.setPreviousEdition(previousEdition);
                modifications.add(m);
            }
        }
        if ((removed = (Element)node.selectSingleNode("./affected-files/removed")) != null) {
            List elements = removed.elements();
            for (Element each : elements) {
                BzrModification m = ChangeLogXMLConsumer.parseModification(each);
                m.setAction(Modification.Action.DELETE);
                m.setEdition(null);
                m.setPreviousEdition(previousEdition);
                modifications.add(m);
            }
        }
        if ((renamed = (Element)node.selectSingleNode("./affected-files/renamed")) != null) {
            List elements = renamed.elements();
            for (Element each : elements) {
                BzrModification m = new BzrModification();
                String fromPath = each.attributeValue("oldpath");
                Modification.PathType pathType = each.getName().equalsIgnoreCase("directory") ? Modification.PathType.DIR : null;
                m.setAction(Modification.Action.DELETE);
                m.setEdition(null);
                m.setPreviousEdition(previousEdition);
                m.setPath(fromPath);
                if (pathType == Modification.PathType.DIR) {
                    m.setPath(StringUtils.stripEnd((String)m.getPath(), (String)"/") + "/");
                }
                m.setPathType(pathType);
                modifications.add(m);
                m = new BzrModification();
                String toPath = each.getText();
                m.setAction(Modification.Action.ADD);
                m.setPath(toPath);
                m.setEdition(c.getId());
                m.setRevno(c.getRevno());
                m.setPreviousEdition(null);
                m.setPathType(pathType);
                if (pathType == Modification.PathType.DIR) {
                    m.setPath(StringUtils.stripEnd((String)m.getPath(), (String)"/") + "/");
                }
                modifications.add(m);
            }
        }
        return modifications;
    }

    private static BzrModification parseModification(Element node) {
        BzrModification m = new BzrModification();
        m.setPath(node.getText());
        if (node.getName().equalsIgnoreCase("directory")) {
            m.setPathType(Modification.PathType.DIR);
        }
        return m;
    }
}

