/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.bazaar.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrChangeset;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ChangeLogConsumer
extends AbstractChangeLogConsumer {
    private List<Changeset> changes = new ArrayList<Changeset>();
    private List<String> changeBlock = new ArrayList<String>();
    private final String excludeId;
    private Map<Integer, Changeset> previousChanges = new HashMap<Integer, Changeset>();
    private int ignoredDepth = 0;
    private boolean ignore = false;
    private static final DateTimeFormatter DATE_FMT = DateTimeFormat.forPattern((String)"EEE yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.US);
    private static final String SEPARATOR = "------------------------------------------------------------";
    private static final Pattern AUTHOR_ENTRY = Pattern.compile("^committer: (.*) <(.*)>(.*)$");
    private static final Pattern REVNO_ENTRY = Pattern.compile("^revno: (.*)$");
    private static final Pattern MODIFICATION_ENTRY = Pattern.compile("^(added|modified|removed|renamed):$");

    public ChangeLogConsumer() {
        this(null);
    }

    public ChangeLogConsumer(String excludeId) {
        this(Log.LogLevel.DEBUG, excludeId);
    }

    public ChangeLogConsumer(Log.LogLevel level, String excludeId) {
        super(level, "UTF-8");
        this.excludeId = excludeId;
    }

    public void consume(String line) {
        int pos;
        int i;
        super.consume(line);
        if (line.trim().equals(SEPARATOR) && (i = (pos = line.indexOf(SEPARATOR)) % 4) == 0) {
            Changeset change = this.parse();
            this.changeBlock = new ArrayList<String>();
            if (change != null) {
                this.changes.add(change);
                this.previousChanges.put(i, change);
            }
        }
        this.changeBlock.add(line);
    }

    @Override
    public List<Changeset> getChanges() {
        Changeset change = this.parse();
        if (change != null) {
            this.changes.add(change);
        }
        this.lines.clear();
        this.changeBlock.clear();
        return this.changes;
    }

    private Changeset parse() {
        if (this.changeBlock.size() < 2) {
            return null;
        }
        String line = this.changeBlock.get(0);
        int pos = line.indexOf(SEPARATOR);
        int depth = pos / 4;
        if (this.ignore) {
            if (depth >= this.ignoredDepth) {
                return null;
            }
            this.ignore = false;
            this.ignoredDepth = 0;
        }
        LogStatus status = LogStatus.REVNO;
        StringBuffer msgBuffer = new StringBuffer();
        ModificationType modificationType = ModificationType.UNKNOWN;
        String previousId = null;
        BzrChangeset change = new BzrChangeset();
        block13: for (int i = 1; i < this.changeBlock.size(); ++i) {
            String each = this.changeBlock.get(i).substring(pos);
            switch (status) {
                case REVNO: {
                    Matcher revm = REVNO_ENTRY.matcher(each);
                    if (!revm.matches()) continue block13;
                    line = each.substring("revno:".length()).trim();
                    int pos2 = line.indexOf(91);
                    String revno = pos2 > 0 ? line.substring(0, pos2).trim() : line;
                    if (revno.equalsIgnoreCase(this.excludeId)) {
                        this.ignore = true;
                        this.ignoredDepth = depth + 1;
                        return null;
                    }
                    change.setRevno(revno);
                    status = status.next();
                    continue block13;
                }
                case REVISION_ID: {
                    if (!each.startsWith("revision-id:")) continue block13;
                    String id = ChangeLogConsumer.getValue(each);
                    if (id.equalsIgnoreCase(this.excludeId)) {
                        this.ignore = true;
                        this.ignoredDepth = depth + 1;
                        return null;
                    }
                    change.setId(id);
                    status = status.next();
                    continue block13;
                }
                case PARENT: 
                case COMMITTER: {
                    if (each.startsWith("parent:") && previousId == null) {
                        previousId = ChangeLogConsumer.getValue(each);
                        status = LogStatus.COMMITTER;
                        continue block13;
                    }
                    if (!each.startsWith("committer:")) continue block13;
                    Matcher m = AUTHOR_ENTRY.matcher(each);
                    if (m.matches()) {
                        change.setUser(m.group(1));
                    }
                    status = LogStatus.TIMESTAMP;
                    continue block13;
                }
                case TIMESTAMP: {
                    if (!each.startsWith("timestamp:")) continue block13;
                    String timestamp = ChangeLogConsumer.getValue(each);
                    change.setDate(DATE_FMT.parseDateTime(timestamp).toDate());
                    status = status.next();
                    continue block13;
                }
                case MESSAGE: {
                    Matcher mm = MODIFICATION_ENTRY.matcher(each);
                    if (mm.matches()) {
                        change.setComment(msgBuffer.toString());
                        status = LogStatus.MODIFICATION;
                        modificationType = ModificationType.fromString(mm.group(1));
                        continue block13;
                    }
                    if (each.equals("message:") || !each.startsWith("  ")) continue block13;
                    msgBuffer.append(each.substring(2));
                    continue block13;
                }
                case MODIFICATION: {
                    Matcher m = MODIFICATION_ENTRY.matcher(each);
                    if (m.matches()) {
                        modificationType = ModificationType.fromString(m.group(1));
                        continue block13;
                    }
                    if (!each.startsWith(" ")) continue block13;
                    int fileIdPos = each.lastIndexOf(" ");
                    String fileLine = each;
                    fileLine = fileIdPos > 0 ? each.substring(0, fileIdPos).trim() : fileLine.trim();
                    if (modificationType == ModificationType.RENAMED) {
                        String[] tokens = StringUtils.split((String)fileLine, (String)"=>");
                        Modification mod = new Modification();
                        mod.setAction(Modification.Action.ADD);
                        mod.setEdition(change.getId());
                        mod.setPreviousEdition(null);
                        mod.setPath(tokens[1].trim());
                        if (mod.getPath().endsWith("/")) {
                            mod.setPathType(Modification.PathType.DIR);
                        }
                        change.getModifications().add(mod);
                        mod = new Modification();
                        mod.setAction(Modification.Action.DELETE);
                        mod.setEdition(null);
                        mod.setPreviousEdition(previousId);
                        mod.setPath(tokens[0].trim());
                        if (mod.getPath().endsWith("/")) {
                            mod.setPathType(Modification.PathType.DIR);
                        }
                        change.getModifications().add(mod);
                        continue block13;
                    }
                    Modification mod = new Modification();
                    switch (modificationType) {
                        case ADDED: {
                            mod.setAction(Modification.Action.ADD);
                            mod.setEdition(change.getId());
                            mod.setPreviousEdition(null);
                            break;
                        }
                        case REMOVED: {
                            mod.setAction(Modification.Action.DELETE);
                            mod.setEdition(null);
                            mod.setPreviousEdition(previousId);
                            break;
                        }
                        case MODIFIED: {
                            mod.setEdition(change.getId());
                            mod.setPreviousEdition(previousId);
                            mod.setAction(Modification.Action.MODIFY);
                            break;
                        }
                    }
                    mod.setPath(fileLine);
                    if (fileLine.endsWith("/")) {
                        mod.setPathType(Modification.PathType.DIR);
                    }
                    change.getModifications().add(mod);
                    continue block13;
                }
            }
        }
        return change;
    }

    private Changeset parse(List<String> origin) {
        int i;
        if (origin.isEmpty()) {
            return null;
        }
        String sep = origin.get(0);
        int pos = sep.indexOf(SEPARATOR);
        if (pos < 0) {
            return null;
        }
        Changeset change = null;
        LogStatus status = LogStatus.REVNO;
        StringBuffer msgBuffer = new StringBuffer();
        ModificationType modificationType = ModificationType.UNKNOWN;
        String previousId = null;
        block13: for (i = 1; i < origin.size(); ++i) {
            String each = origin.get(i).substring(pos);
            switch (status) {
                case REVNO: {
                    Matcher revm = REVNO_ENTRY.matcher(each);
                    if (!revm.matches()) continue block13;
                    change = new Changeset();
                    String line = each.substring("revno:".length()).trim();
                    int pos2 = line.indexOf(91);
                    if (pos2 > 0) {
                        // empty if block
                    }
                    status = status.next();
                    continue block13;
                }
                case REVISION_ID: {
                    if (!each.startsWith("revision-id:")) continue block13;
                    String id = ChangeLogConsumer.getValue(each);
                    change.setId(id);
                    status = status.next();
                    continue block13;
                }
                case PARENT: 
                case COMMITTER: {
                    if (each.startsWith("parent:") && previousId == null) {
                        previousId = ChangeLogConsumer.getValue(each);
                        status = LogStatus.COMMITTER;
                        continue block13;
                    }
                    if (!each.startsWith("committer:")) continue block13;
                    Matcher m = AUTHOR_ENTRY.matcher(each);
                    if (m.matches()) {
                        change.setUser(m.group(1));
                    }
                    status = LogStatus.TIMESTAMP;
                    continue block13;
                }
                case TIMESTAMP: {
                    if (!each.startsWith("timestamp:")) continue block13;
                    String timestamp = ChangeLogConsumer.getValue(each);
                    change.setDate(DATE_FMT.parseDateTime(timestamp).toDate());
                    status = status.next();
                    continue block13;
                }
                case MESSAGE: {
                    Matcher mm = MODIFICATION_ENTRY.matcher(each);
                    if (mm.matches()) {
                        change.setComment(msgBuffer.toString());
                        status = LogStatus.MODIFICATION;
                        modificationType = ModificationType.fromString(mm.group(1));
                        continue block13;
                    }
                    if (each.equals("message:") || !each.startsWith("  ")) continue block13;
                    msgBuffer.append(each.substring(2));
                    continue block13;
                }
                case MODIFICATION: {
                    Matcher m = MODIFICATION_ENTRY.matcher(each);
                    if (m.matches()) {
                        modificationType = ModificationType.fromString(m.group(1));
                        continue block13;
                    }
                    if (!each.startsWith(" ")) continue block13;
                    int fileIdPos = each.lastIndexOf(" ");
                    String fileLine = each;
                    fileLine = fileIdPos > 0 ? each.substring(0, fileIdPos).trim() : fileLine.trim();
                    if (modificationType == ModificationType.RENAMED) {
                        String[] tokens = StringUtils.split((String)fileLine, (String)"=>");
                        Modification mod = new Modification();
                        mod.setAction(Modification.Action.ADD);
                        mod.setEdition(change.getId());
                        mod.setPreviousEdition(null);
                        mod.setPath(tokens[1].trim());
                        if (mod.getPath().endsWith("/")) {
                            mod.setPathType(Modification.PathType.DIR);
                        }
                        change.getModifications().add(mod);
                        mod = new Modification();
                        mod.setAction(Modification.Action.DELETE);
                        mod.setEdition(null);
                        mod.setPreviousEdition(previousId);
                        mod.setPath(tokens[0].trim());
                        if (mod.getPath().endsWith("/")) {
                            mod.setPathType(Modification.PathType.DIR);
                        }
                        change.getModifications().add(mod);
                        continue block13;
                    }
                    Modification mod = new Modification();
                    switch (modificationType) {
                        case ADDED: {
                            mod.setAction(Modification.Action.ADD);
                            mod.setEdition(change.getId());
                            mod.setPreviousEdition(null);
                            break;
                        }
                        case REMOVED: {
                            mod.setAction(Modification.Action.DELETE);
                            mod.setEdition(null);
                            mod.setPreviousEdition(previousId);
                            break;
                        }
                        case MODIFIED: {
                            mod.setEdition(change.getId());
                            mod.setPreviousEdition(previousId);
                            mod.setAction(Modification.Action.MODIFY);
                            break;
                        }
                    }
                    mod.setPath(fileLine);
                    if (fileLine.endsWith("/")) {
                        mod.setPathType(Modification.PathType.DIR);
                    }
                    change.getModifications().add(mod);
                    continue block13;
                }
            }
        }
        if (pos > 0) {
            for (i = 0; i < pos / 4; ++i) {
            }
        }
        return change;
    }

    private static String getValue(String line) {
        int pos = line.indexOf(":");
        return line.substring(pos + 1).trim();
    }

    private static enum ModificationType {
        ADDED,
        MODIFIED,
        REMOVED,
        RENAMED,
        UNKNOWN;


        public static ModificationType fromString(String str) {
            try {
                return ModificationType.valueOf(str.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }

    private static enum LogStatus {
        REVNO,
        REVISION_ID,
        PARENT,
        COMMITTER,
        TIMESTAMP,
        MESSAGE,
        MODIFICATION,
        UNKNOWN;


        public LogStatus next() {
            return LogStatus.values()[this.ordinal() + 1];
        }
    }
}

