/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.scm.bazaar.BazaarCli;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrRepository;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class BzrSourceViewSupport
extends SourceViewSupport<BzrRevision> {
    public BzrSourceViewSupport(BzrRepository repository) {
        super((Repository)repository);
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            String checkoutFileCanonicalPath = checkoutFile.getCanonicalPath();
            String destDirCanonicalPath = this.getRepository().getWorkingDir().getCanonicalPath();
            Context.getLogger().debug("Calculating repository path...");
            Context.getLogger().debug("Path to checkout file: " + checkoutFileCanonicalPath);
            Context.getLogger().debug("Path to repository destination directory: " + destDirCanonicalPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getWorkingDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        return relativePath;
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return new BazaarCli(this.getRepository()).cat(repositoryPath, edition);
    }

    public List<String> readSourceByRevision(String repositoryPath, BzrRevision revision) {
        return new BazaarCli(this.getRepository()).cat(repositoryPath, revision.toString());
    }

    public BzrRepository getRepository() {
        return (BzrRepository)super.getRepository();
    }
}

