/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.bazaar.BazaarCli;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrPluginSetting;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrRevision;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrUrl;
import com.pmease.quickbuild.plugin.scm.bazaar.CliVersion;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.TooBigXMLLogException;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.repositorysupport.WorkingDirLocator;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Bazaar", description="Configure a Bazaar repository here. By default, QuickBuild executes \"bzr\" to checkout from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Bazaar plugin through the plugin management page.")
@ScriptApi
public class BzrRepository
extends AbstractRepository<BzrRevision> {
    private static final long serialVersionUID = 1L;
    private String url;
    private String userName;
    private String password;
    private String buildRevision;
    private String destPath;
    private transient CliVersion bzrVersion;
    private BzrProofBuildSupport proofBuildSupport;
    private static final String DOT_BZR = ".bzr";

    public boolean exists() {
        return this.getWorkingDir().exists() && this.dotBzr().exists();
    }

    public File dotBzr() {
        return new File(this.getWorkingDir(), DOT_BZR);
    }

    public Properties getCurrentRC() {
        Properties props = new Properties();
        props.put("url", this.getActualUrl(true));
        return props;
    }

    private BazaarCli getBazaar() {
        return (BazaarCli)new BazaarCli(this).sync();
    }

    protected void checkoutByRevision(BzrRevision revision) {
        this.getBazaar().checkout(revision.toString());
    }

    private boolean isValidRevision(BzrRevision rev) {
        if (StringUtils.isEmpty((String)rev.getValue())) {
            return false;
        }
        return this.getUrl().equalsIgnoreCase(rev.getBranchUrl());
    }

    protected List<Changeset> getChangesBetween(BzrRevision startRevision, BzrRevision endRevision) {
        try {
            if (!this.isValidRevision(startRevision)) {
                this.getLogger().info("Start revsion " + (Object)((Object)startRevision) + " is in a different branch, ignore calculating changes");
                return Collections.emptyList();
            }
            if (!this.isValidRevision(endRevision)) {
                this.getLogger().info("End revsion " + (Object)((Object)startRevision) + " is in a different branch, ignore calculating changes");
                return Collections.emptyList();
            }
            return this.getBazaar().changesBetween(startRevision.toString(), endRevision.toString());
        }
        catch (TooBigXMLLogException e) {
            Context.getLogger().warn("There are too many changes between " + (Object)((Object)startRevision) + " and " + (Object)((Object)endRevision) + ". Ignore calculating changes");
            return Collections.emptyList();
        }
    }

    protected BzrRevision getHeadRevision() {
        String rev = StringUtils.isEmpty((String)this.getBuildRevision()) ? this.getBazaar().revision(null) : this.getBazaar().revision(this.getBuildRevision());
        if (StringUtils.isEmpty((String)rev) || "0".equals(rev)) {
            throw new ScmException("Can not detect the correct revision of repository " + (Object)((Object)this));
        }
        return new BzrRevision(rev, this.getUrl());
    }

    @Editable(order=700, description="Check this to enable proof build for this repository.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public BzrProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(BzrProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    public SourceViewSupport<BzrRevision> getSourceViewSupport() {
        return new WorkingDirLocator((SourceViewSupport)new BzrSourceViewSupport(this));
    }

    protected boolean isQuietSince(Date date) {
        Changeset c = this.getBazaar().tip(null);
        if (c == null) {
            return true;
        }
        Date cdate = c.getDate();
        if (cdate == null) {
            throw new ScmException("Failed parse Bazaar output, please turn on configuration log level to debug and run again, and then send the log to support@pmease.com.");
        }
        return cdate.before(date);
    }

    protected void labelOnRevision(BzrRevision revision, String label, String comment) {
        this.getBazaar().tag(revision.toString(), label, comment);
    }

    @Editable(order=1000, name="Checkout Url", description="Specify the repository url to checkout, for example:<ul><li>bzr+ssh://buildmachine/home/bzr/repository/myproject/trunk</li><li>http://buildmachine/repository/myproject/branches/2.0</li></ul><strong>NOTE:</strong> If you are using <b>https://</b> or <b>bzr+ssh://</b> schema, you should make sure that bzr server certificate has been accepted permanently by your build machine for the same user account the QuickBuild process is running as")
    @NotEmpty
    @ScriptApi(value="Get URL of the repository to checkout from.")
    @Scriptable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getActualUrl(boolean descriptive) {
        return this.getActualUrl(this.getUrl(), descriptive);
    }

    private String getActualUrl(String url, boolean descriptive) {
        BzrUrl burl = new BzrUrl(url, this.getUserName(), this.getPassword());
        if (descriptive) {
            return burl.toDescriptiveString();
        }
        return burl.toString();
    }

    @Editable(order=1200, name="User name", description="Optionally specify the user who has permission to access the above url.")
    @ScriptApi(value="Get the user name used to login the remote repository.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=1300, description="Specify password of the above user.<br><span class='bold red'>IMPORTANT:</span> For SSH based protocols (ssh, scp, sftp), specifying password here will not work. Please use public key authentication without pass phrase instead to avoid hanging. Refer to http://wiki.pmease.com for details.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=1400, name="Destination Path", description="Specify the destination path to which contents in the above url will be retrieved into. This path is relative to the running configuration's workspace. If left empty, the workspace directory itself will be used to put checked out contents.")
    @ScriptApi(value="Get destination path to put checked out files. Null if workspace directory is used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=1800, name="Revision Spec to Build", description="Optionally specify a revision spec to build against. For example: <i>revno:100</i>, <i>tag:1.0.0</i>. If not specified, the head revision of the above url will be checked out.")
    @ScriptApi(value="Get specified revision to build against. Null if build against head revision.")
    @Scriptable
    public String getBuildRevision() {
        return this.buildRevision;
    }

    public void setBuildRevision(String buildRevision) {
        this.buildRevision = buildRevision;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append(" (");
        if (!StringUtils.isEmpty((String)this.getUserName())) {
            sb.append(this.getUserName()).append("@");
        }
        sb.append(this.getUrl());
        sb.append(")");
        return sb.toString();
    }

    String getBzrPath() {
        BzrPluginSetting setting = BzrPluginSetting.get();
        String path = setting.getBzrExePath();
        if (StringUtils.isEmpty((String)path)) {
            return "bzr";
        }
        return path;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element pushUrlElement = dom.getRootElement().element("pushUrl");
        if (pushUrlElement != null) {
            pushUrlElement.detach();
        }
    }

    @ScriptApi(value="Get current Bazaar client version")
    public CliVersion getBzrVersion() {
        if (this.bzrVersion == null) {
            this.bzrVersion = this.getBazaar().getVersion();
        }
        return this.bzrVersion;
    }

    public String format(String field, Map<String, Object> map) {
        AbstractRepository.FormatType t = AbstractRepository.FormatType.valueOf((String)field.toUpperCase());
        switch (t) {
            case CHANGEID: {
                String revno = (String)map.get("additional");
                if (StringUtils.isEmpty((String)revno)) {
                    return (String)map.get("changeId");
                }
                return revno;
            }
            case EDITION: {
                String edition = (String)map.get("additional");
                if (!StringUtils.isEmpty((String)edition)) {
                    return edition;
                }
                edition = (String)map.get("edition");
                int pos = edition.lastIndexOf(45);
                if (pos > 0) {
                    edition = edition.substring(pos + 1);
                }
                return edition;
            }
        }
        throw new IllegalArgumentException("Unknown field: " + field);
    }
}

