/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrRepository;
import com.pmease.quickbuild.plugin.scm.bazaar.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Transient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.validator.constraints.NotEmpty;

public class BzrProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private static final long serialVersionUID = 1L;
    private BzrRepository repository;
    private String localPath;
    private String revision;
    private String mergeCondition = "true";
    private String pushCondition = "build.successful";
    @Transient
    private String parentBranch;

    public BzrProofBuildSupport(BzrRepository repository) {
        this.repository = repository;
    }

    @Editable(name="Local Repository Path", order=100, description="Specify path to your standalone local Bazaar repository (ie. not created without checkout). QuickBuild will send local commits (commits found in local repository but missed in push branch) to run proof build.<br><span class='bold red'>IMPORTANT:</span> The parent branch of this local repository ought to point to the remote repository defined above, and the merge/push operation should not prompt for any user name or password.")
    @Scriptable
    @ScriptApi(value="Get path to local Bazaar repository. Will not be null.")
    @NotEmpty
    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Editable(name="Revision Spec to Verify", order=200, description="Optionally specify a revision spec in local repository for proof build. For example: <i>revno:100</i>, <i>tag:1.0.0</i>. All ancestor revisions of specified revision will also be verified. If left empty, all revisions missing in parent branch will be verified.")
    @ScriptApi(value="Get revision spec for proof build. Null if not specified.")
    @Scriptable
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Editable(name="Merge Condition", order=400, description="This condition only takes effect when revision is not specified above, and can make proof build more accurate when dealing with pushed commits of other developers. If satisfied, QuickBuild will merge commits pushed by other developers into the local repository before collecting outgoing change sets.")
    @Expressions(value={"always merge", "true", "do not merge", "false"})
    @ScriptApi(value="Get merge condition. Will not be null.")
    @Scriptable
    @NotEmpty
    public String getMergeCondition() {
        return this.mergeCondition;
    }

    public void setMergeCondition(String mergeCondition) {
        this.mergeCondition = mergeCondition;
    }

    @Editable(name="Push Condition", order=500, description="Specify the condition to push verified commits. If this condition is satisfied, missing revisions up to specified revision above will be pushed to this repository after the build finishes.")
    @Expressions(value={"push only when build is successful", "build.successful", "always push", "true", "do not push", "false"})
    @Scriptable
    @ScriptApi(value="Get push condition. Will not be null.")
    @NotEmpty
    public String getPushCondition() {
        return this.pushCondition;
    }

    public void setPushCondition(String pushCondition) {
        this.pushCondition = pushCondition;
    }

    @ScriptApi(value="Get repository object.")
    public BzrRepository getRepository() {
        return this.repository;
    }

    public void buildFinished() {
        ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        if (((Boolean)scriptEngine.evaluate(this.getPushCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
            if (this.getRevision() != null) {
                Validate.notNull((Object)this.parentBranch);
                Context.getLogger().info("Pushing local commits...");
                final boolean[] branchDiverged = new boolean[]{false};
                Commandline cmd = this.buildBzrCmd().addArgLine("push -r").addArgValue(this.getRevision()).addArgValue(this.parentBranch);
                Commandline.ExecuteResult result = cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        if (line.contains("These branches have diverged")) {
                            branchDiverged[0] = true;
                        }
                    }
                }, new LineConsumer(){

                    public void consume(String line) {
                        if (line.contains("All changes applied successfully") || line.contains("Pushed up to revision") || line.startsWith("This transport does not update the working tree")) {
                            Context.getLogger().info(line);
                        } else {
                            Context.getLogger().error(line);
                        }
                    }
                });
                if (branchDiverged[0]) {
                    throw new ScmException("Parent branch diverged due to new commits from others since your last merge. Please merge with these new commits (or have QuickBuild proof build to do it automatically) and run proof build again.");
                }
                result.checkReturnCode();
            } else {
                Context.getLogger().info("No local commits to push.");
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return new File(this.repository.getWorkingDir(), repositoryPath);
    }

    public LocalChange getLocalChange(File changeStoreDir) {
        List<Changeset> changes;
        Commandline cmd = this.buildBzrCmd().addArgLine("info");
        Context.getLogger().info("Checking parent branch of local repository...");
        cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                if (line.trim().startsWith("parent branch:")) {
                    BzrProofBuildSupport.this.parentBranch = StringUtils.substringAfter((String)line, (String)":").trim();
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        if (this.parentBranch == null) {
            throw new ScmException("Proof build can not be done against a local repository created with checkout.");
        }
        Commandline missingCmd = this.buildBzrCmd().addArgValue("missing").addArgValue(this.parentBranch).addArgLine("--this --reverse -v --show-ids");
        if (this.getRevision() == null) {
            ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
            if (((Boolean)scriptEngine.evaluate(this.getMergeCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
                cmd = this.buildBzrCmd().addArgValue("status");
                Context.getLogger().info("Checking if there are uncommitted files...");
                final boolean[] commitClean = new boolean[]{true};
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().info(line);
                        if (line.startsWith("modified") || line.startsWith("added") || line.startsWith("removed") || line.startsWith("conflicts") || line.startsWith("renamed")) {
                            commitClean[0] = false;
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                if (!commitClean[0]) {
                    throw new ScmException("QuickBuild can not proceed to merge with incoming change sets since there are uncommitted files in your working directory.");
                }
                cmd = this.buildBzrCmd().addArgValue("merge").addArgValue(this.parentBranch);
                Context.getLogger().info("Merging with other developers' commits...");
                final boolean[] needToCommit = new boolean[]{true};
                final boolean[] conflictsFound = new boolean[]{false};
                Commandline.ExecuteResult result = cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                    public void consume(String line) {
                        if (line.contains("Nothing to do")) {
                            needToCommit[0] = false;
                            Context.getLogger().info(line);
                        } else if (line.contains("conflicts encountered")) {
                            conflictsFound[0] = true;
                            Context.getLogger().error(line);
                        } else if (line.startsWith("Text conflict in") || line.startsWith("Conflict")) {
                            Context.getLogger().error(line);
                        } else {
                            Context.getLogger().info(line);
                        }
                    }
                });
                if (conflictsFound[0]) {
                    throw new ScmException("Merge conflicts found, please resolve and commit first, and then run proof bulid again.");
                }
                result.checkReturnCode();
                if (needToCommit[0]) {
                    Context.getLogger().info("Commiting merged result...");
                    cmd = this.buildBzrCmd().addArgLine("ci -m").addArgValue("Merged as result of running QuickBuild proof build.");
                    cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                        public void consume(String line) {
                            if (line.startsWith("Committing to") || line.startsWith("modified") || line.startsWith("Committed") || line.startsWith("added") || line.startsWith("renamed") || line.startsWith("deleted")) {
                                Context.getLogger().info(line);
                            } else {
                                Context.getLogger().error(line);
                            }
                        }
                    }).checkReturnCode();
                }
            }
        } else {
            missingCmd.addArgLine("--my-revision .." + this.getRevision());
        }
        Context.getLogger().info("Checking local commits...");
        final ChangeLogConsumer consumer = new ChangeLogConsumer();
        final boolean[] missingFound = new boolean[]{false};
        Commandline.ExecuteResult result = missingCmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.endsWith("extra revision(s):")) {
                    missingFound[0] = true;
                } else if (missingFound[0]) {
                    consumer.consume(line);
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger());
        if (missingFound[0]) {
            changes = consumer.getChanges();
        } else {
            result.checkReturnCode();
            changes = new ArrayList<Changeset>();
        }
        ArrayList mergedModifications = new ArrayList();
        for (Changeset change : changes) {
            final ArrayList modifications = new ArrayList(change.getModifications());
            for (final Modification modification : change.getModifications()) {
                if (modification.getPathType() != Modification.PathType.DIR) continue;
                if (modification.getAction() == Modification.Action.DELETE) {
                    cmd = this.buildBzrCmd().addArgLine("ls -R -r").addArgValue("revid:" + modification.getPreviousEdition()).addArgValue(StringUtils.stripEnd((String)modification.getPath(), (String)"/"));
                    cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            if (StringUtils.isNotBlank((String)line)) {
                                Modification derivedMod = new Modification();
                                derivedMod.setAction(Modification.Action.DELETE);
                                derivedMod.setPath(line);
                                derivedMod.setPreviousEdition(modification.getPreviousEdition());
                                modifications.add(derivedMod);
                            }
                        }
                    }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                    continue;
                }
                if (modification.getAction() != Modification.Action.ADD) continue;
                cmd = this.buildBzrCmd().addArgLine("ls -R -r").addArgValue("revid:" + modification.getEdition()).addArgValue(StringUtils.stripEnd((String)modification.getPath(), (String)"/"));
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        if (StringUtils.isNotBlank((String)line)) {
                            Modification derivedMod = new Modification();
                            derivedMod.setAction(Modification.Action.ADD);
                            derivedMod.setPath(line);
                            derivedMod.setEdition(modification.getEdition());
                            modifications.add(derivedMod);
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            }
            Modification.merge(mergedModifications, modifications);
            this.setRevision("revid:" + change.getId());
        }
        LocalChange localChange = new LocalChange();
        for (Modification each : mergedModifications) {
            if (each.getAction() == Modification.Action.DELETE) {
                localChange.getDeletePaths().add(each.getPath());
                continue;
            }
            if (each.getAction() == Modification.Action.ADD) {
                localChange.getAddPaths().add(each.getPath());
            } else {
                localChange.getModifyPaths().add(each.getPath());
            }
            File destFile = new File(changeStoreDir, each.getPath());
            FileUtils.createDir((File)destFile.getParentFile());
            if (each.getPath().endsWith("/")) {
                FileUtils.createDir((File)destFile);
                continue;
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(destFile);
                this.buildBzrCmd().addArgLine("cat -r").addArgValue("revid:" + each.getEdition()).addArgValue(each.getPath()).execute(this.getWorkingDir(), (OutputStream)os, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        return localChange;
    }

    private File getWorkingDir() {
        return new File(this.getLocalPath());
    }

    private Commandline buildBzrCmd() {
        return new Commandline().setExecutable(this.repository.getBzrPath());
    }
}

