/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.bazaar;

import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.bazaar.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrCommand;
import com.pmease.quickbuild.plugin.scm.bazaar.BzrRepository;
import com.pmease.quickbuild.plugin.scm.bazaar.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.ChangeLogXMLConsumer;
import com.pmease.quickbuild.plugin.scm.bazaar.CliVersion;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCli;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class BazaarCli
extends ScmCli<BazaarCli, BzrRepository, BzrCommand> {
    private static final Pattern VERSION_ENTRY = Pattern.compile("Bazaar \\(bzr\\) (\\d+)\\.(\\d+)\\.(\\d+)(.*)$");
    private static final CliVersion NO_UPDATE_VERSION = new CliVersion(2, 1, 0);
    private static final CliVersion NO_XML_VERSION = new CliVersion(2, 2, 0);

    public BazaarCli(BzrRepository repository) {
        super((AbstractRepository)repository, "UTF-8");
    }

    public CliVersion getVersion() {
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        BzrCommand cmd = (BzrCommand)this.buildCommand("version");
        this.run(cmd, (LineConsumer)consumer);
        String line = consumer.firstLine();
        Matcher m = VERSION_ENTRY.matcher(line);
        if (m.matches() && m.groupCount() >= 3) {
            CliVersion version = new CliVersion();
            version.setMajor(Integer.valueOf(m.group(1)));
            version.setMinor(Integer.valueOf(m.group(2)));
            version.setBeta(Integer.valueOf(m.group(3)));
            return version;
        }
        throw new ScmException("Unknown bazaar version");
    }

    public BazaarCli checkout(String revision) {
        if (StringUtils.isEmpty((String)revision)) {
            throw new ScmException("Revision should be specified before checkout");
        }
        File workingDir = this.getWorkingDir();
        if (((BzrRepository)this.repository).exists()) {
            if (((BzrRepository)this.repository).getBzrVersion().compareTo(NO_UPDATE_VERSION) <= 0) {
                this.run(((BzrCommand)this.buildCommand("revert -r", "revid:" + revision)).quiet(), (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
            } else {
                this.run(((BzrCommand)this.buildCommand("update -r ", "revid:" + revision)).quiet(), (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
            }
        } else {
            FileUtils.createDir((File)workingDir);
            BzrCommand command = ((BzrCommand)this.buildCommand("checkout --lightweight ")).quiet();
            command.addParameter("-r", "revid:" + revision);
            command.setValue(((BzrRepository)this.repository).getActualUrl(false), ((BzrRepository)this.repository).getActualUrl(true));
            command.setValue(workingDir.getAbsolutePath());
            this.run(command, (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
        }
        return this;
    }

    private List<Changeset> changes(BzrCommand command, String excludeId) {
        AbstractChangeLogConsumer consumer = ((BzrRepository)this.repository).getBzrVersion().compareTo(NO_XML_VERSION) < 0 ? new ChangeLogConsumer(excludeId) : new ChangeLogXMLConsumer(excludeId);
        command.setValue(((BzrRepository)this.repository).getActualUrl(false), ((BzrRepository)this.repository).getActualUrl(true));
        this.run(command, (LineConsumer)consumer);
        return consumer.getChanges();
    }

    private BzrCommand logCommand() {
        if (((BzrRepository)this.repository).getBzrVersion().compareTo(NO_XML_VERSION) < 0) {
            return (BzrCommand)this.buildCommand("log -v --show-ids");
        }
        return (BzrCommand)this.buildCommand("log -v --show-ids --xml");
    }

    public Changeset tip(String revspec) {
        List<Changeset> changes;
        BzrCommand command = this.logCommand();
        command.setValue("-l1");
        if (!StringUtils.isEmpty((String)revspec)) {
            command.setLine("-r");
            command.setValue(revspec);
        }
        if ((changes = this.changes(command, null)).isEmpty()) {
            return null;
        }
        return changes.get(0);
    }

    public String revision(String revspec) {
        Changeset tip = this.tip(revspec);
        if (tip == null) {
            return null;
        }
        return tip.getId();
    }

    private Date getRevDate(String revspec) {
        BzrCommand command = this.logCommand();
        command.setValue("-l1");
        command.addParameter("-r", "revid:" + revspec);
        List<Changeset> changes = this.changes(command, null);
        if (changes.isEmpty()) {
            return null;
        }
        return changes.get(0).getDate();
    }

    public List<Changeset> changesBetween(String from, String to) {
        Date date1 = this.getRevDate(from);
        Date date2 = this.getRevDate(to);
        if (date1 == null) {
            this.getLogger().warn("Revision " + from + " is not a valid bazaar revision");
            return Collections.emptyList();
        }
        if (date2 == null) {
            this.getLogger().warn("Revision " + to + " is not a valid bazaar revision");
            return Collections.emptyList();
        }
        if (date1.after(date2)) {
            this.getLogger().info("Start revision '" + from + "' is elder than end revision '" + to + "', ignore calculating changes.");
            return Collections.emptyList();
        }
        BzrCommand command = this.logCommand();
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)from)) {
            sb.append("revid:" + from);
        }
        sb.append("..");
        if (!StringUtils.isEmpty((String)to)) {
            sb.append("revid:" + to);
        }
        command.addArgLine("-n0");
        command.addParameter("-r", sb.toString());
        return this.changes(command, from);
    }

    public List<Changeset> changesSince(Date date, int n) {
        BzrCommand command = this.logCommand();
        if (n > 0) {
            command.setValue("-l" + n);
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
        command.addParameter("-r", "date:" + fmt.format(date) + "..");
        return this.changes(command, null);
    }

    public BazaarCli tag(String rev, String label, String comment) {
        BzrCommand command = ((BzrCommand)this.buildCommand("tag --force ")).quiet();
        command.addParameter("-r", "revid:" + rev);
        command.addParameter("-d", ((BzrRepository)this.repository).getActualUrl(false), ((BzrRepository)this.repository).getActualUrl(true));
        command.setValue(label);
        return (BazaarCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    private BzrCommand catCommand(String revspec) {
        BzrCommand command = ((BzrCommand)this.buildCommand("cat")).quiet();
        command.addParameter("-r", "revid:" + revspec);
        return command;
    }

    public List<String> cat(String repositoryPath, String revspec) {
        if (StringUtils.isEmpty((String)revspec) || "0".equals(revspec)) {
            this.getLogger().error("Failed to read file '" + repositoryPath + " due to the revision is null or zero which is in valid.");
            return null;
        }
        BzrCommand command = this.catCommand(revspec);
        String path = StringUtils.stripEnd((String)((BzrRepository)this.repository).getUrl(), (String)"\\/") + "/" + StringUtils.stripStart((String)repositoryPath, (String)"\\/");
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        command.setValue(path);
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, "UTF-8");
        this.run(command, (LineConsumer)consumer);
        return consumer.getLines();
    }

    protected BzrCommand createCommand() {
        BzrCommand cmd = new BzrCommand((BzrRepository)this.repository);
        cmd.setSecretMasker(new SecretMasker(){

            public String mask(String message) {
                if (((BzrRepository)BazaarCli.this.getRepository()).getPassword() != null) {
                    return StringUtils.replace((String)message, (String)(":" + ((BzrRepository)BazaarCli.this.getRepository()).getPassword() + "@"), (String)":******@");
                }
                return message;
            }
        });
        return cmd;
    }

    protected void doSync() {
        File workingDir = this.getWorkingDir();
        if (!workingDir.exists()) {
            FileUtils.createDir((File)workingDir);
        }
    }
}

