/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractLobType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;

public class SerializableToBlobType
extends AbstractLobType
implements ParameterizedType {
    public static final String CLASS_NAME = "classname";
    private Class serializableClass;
    private SerializableType type;

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    public Class getReturnedClass() {
        return this.serializableClass;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) {
        return this.type.isEqual(x, y);
    }

    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor session) {
        return this.type.getHashCode(x, null);
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        Blob blob = rs.getBlob(name);
        if (rs.wasNull()) {
            return null;
        }
        int length = (int)blob.length();
        byte[] primaryResult = blob.getBytes(1L, length);
        return this.fromBytes(primaryResult);
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private Object fromBytes(byte[] bytes) throws SerializationException {
        return SerializationHelper.deserialize(bytes, this.getReturnedClass().getClassLoader());
    }

    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        if (value != null) {
            byte[] toSet = SerializableToBlobType.toBytes(value);
            if (session.getFactory().getDialect().useInputStreamToInsertBlob()) {
                st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(toSet), toSet.length);
                if (System.getProperty("VALIDATE_BLOB") != null) {
                    File clueFile = new File(Bootstrap.getLogsDir(), "clue");
                    if (!clueFile.exists()) {
                        FileUtils.createFile(clueFile);
                    }
                    try {
                        Context.getLogger().debug("Validating blob: " + this.fromBytes(toSet).getClass());
                    }
                    catch (Exception e) {
                        PrintWriter pw = null;
                        try {
                            pw = new PrintWriter(new FileOutputStream(clueFile, true));
                            e.printStackTrace(pw);
                        }
                        catch (FileNotFoundException e2) {
                            throw new RuntimeException(e2);
                        }
                        finally {
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                }
            } else {
                st.setBlob(index, Hibernate.getLobCreator((SessionImplementor)session).createBlob(toSet));
            }
        } else {
            st.setNull(index, this.sqlTypes(null)[0]);
        }
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        this.type.setToXMLNode(node, value, factory);
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.type.toLoggableString(value, factory);
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return this.type.fromXMLNode(xml, factory);
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return this.type.deepCopy(value, null, null);
    }

    public boolean isMutable() {
        return this.type.isMutable();
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.type.replace(original, target, session, owner, copyCache);
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return this.type.toColumnNullness(value, mapping);
    }

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String className = parameters.getProperty(CLASS_NAME);
            if (className == null) {
                throw new MappingException("No class name defined for type: " + SerializableToBlobType.class.getName());
            }
            try {
                this.serializableClass = ReflectHelper.classForName((String)className);
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Unable to load class from classname parameter", (Throwable)e);
            }
        }
        this.type = new SerializableType(this.serializableClass);
    }
}

