/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.util.ServletUtils;
import com.pmease.quickbuild.web.WebSession;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.Protocol;
import org.apache.wicket.protocol.https.SwitchProtocolRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageRequestHandler;

class SecureRequestChecker {
    SecureRequestChecker() {
    }

    IRequestHandler checkSecureIncoming(IRequestHandler requestHandler, HttpsConfig httpsConfig) {
        if (requestHandler instanceof SwitchProtocolRequestHandler) {
            return requestHandler;
        }
        Class<?> pageClass = this.getPageClass(requestHandler);
        if (pageClass != null) {
            IRequestHandler redirect = null;
            if (this.forceSecureConnection(pageClass)) {
                if (!ServletUtils.isSecureRequest((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest())) {
                    redirect = SwitchProtocolRequestHandler.requireProtocol((Protocol)Protocol.HTTPS, (HttpsConfig)httpsConfig);
                }
            } else if (ServletUtils.isSecureRequest((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest())) {
                redirect = SwitchProtocolRequestHandler.requireProtocol((Protocol)Protocol.HTTP, (HttpsConfig)httpsConfig);
            }
            if (redirect != null) {
                return redirect;
            }
        }
        return requestHandler;
    }

    private boolean forceSecureConnection(Class<?> pageClass) {
        if (WebSession.get().isCreatedByHttps()) {
            return true;
        }
        if (Context.getUser() != null) {
            for (Group group : CacheManager.instance.getGroups(Context.getUser().getId())) {
                if (!group.isForceHttps()) continue;
                return true;
            }
        } else {
            Group anonymous = CacheManager.instance.getGroup("anonymous");
            if (anonymous != null && anonymous.isForceHttps()) {
                return true;
            }
        }
        return false;
    }

    public Protocol getProtocol(IRequestHandler requestHandler) {
        Class<?> pageClass = this.getPageClass(requestHandler);
        if (pageClass != null) {
            if (this.forceSecureConnection(pageClass)) {
                if (ServletUtils.isSecureRequest((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest())) {
                    return Protocol.PRESERVE_CURRENT;
                }
                return Protocol.HTTPS;
            }
            if (!ServletUtils.isSecureRequest((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest())) {
                return Protocol.PRESERVE_CURRENT;
            }
            return Protocol.HTTP;
        }
        return Protocol.PRESERVE_CURRENT;
    }

    private Class<?> getPageClass(IRequestHandler handler) {
        if (handler instanceof IPageRequestHandler) {
            return ((IPageRequestHandler)handler).getPageClass();
        }
        return null;
    }
}

