/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.SecureRequestChecker;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;

public class SecureMapper
implements IRequestMapper {
    private final IRequestMapper delegate;
    private final HttpsConfig httpsConfig = new HttpsConfig(Bootstrap.getPort(), Bootstrap.getSSLPort());
    private final SecureRequestChecker checker;

    public SecureMapper(IRequestMapper delegate) {
        this.delegate = delegate;
        this.checker = new SecureRequestChecker();
    }

    public IRequestHandler mapRequest(Request request) {
        IRequestHandler requestHandler = this.delegate.mapRequest(request);
        if (requestHandler != null) {
            IRequestHandler httpsHandler = this.checker.checkSecureIncoming(requestHandler, this.httpsConfig);
            if (this.httpsConfig.isPreferStateful()) {
                Session.get().bind();
            }
            requestHandler = httpsHandler;
        }
        return requestHandler;
    }

    public int getCompatibilityScore(Request request) {
        return this.delegate.getCompatibilityScore(request);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.delegate.mapHandler(requestHandler);
        switch (this.checker.getProtocol(requestHandler)) {
            case HTTP: {
                url.setProtocol("http");
                url.setPort(Integer.valueOf(this.httpsConfig.getHttpPort()));
                break;
            }
            case HTTPS: {
                url.setProtocol("https");
                url.setPort(Integer.valueOf(this.httpsConfig.getHttpsPort()));
            }
        }
        return url;
    }
}

