/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.servlet.ResponseIOException;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;

public class ServletWebResponse
extends WebResponse {
    private final HttpServletResponse httpServletResponse;
    private final ServletWebRequest webRequest;
    private boolean redirect = false;

    public ServletWebResponse(ServletWebRequest webRequest, HttpServletResponse httpServletResponse) {
        Args.notNull((Object)webRequest, (String)"webRequest");
        Args.notNull((Object)httpServletResponse, (String)"httpServletResponse");
        this.httpServletResponse = httpServletResponse;
        this.webRequest = webRequest;
    }

    public void addCookie(Cookie cookie) {
        this.httpServletResponse.addCookie(cookie);
    }

    public void clearCookie(Cookie cookie) {
        cookie.setMaxAge(0);
        cookie.setValue(null);
        this.addCookie(cookie);
    }

    public void setContentLength(long length) {
        this.httpServletResponse.addHeader("Content-Length", Long.toString(length));
    }

    public void setContentType(String mimeType) {
        this.httpServletResponse.setContentType(mimeType);
    }

    public void setDateHeader(String name, Time date) {
        Args.notNull((Object)date, (String)"date");
        this.httpServletResponse.setDateHeader(name, date.getMilliseconds());
    }

    public void setHeader(String name, String value) {
        this.httpServletResponse.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.httpServletResponse.addHeader(name, value);
    }

    public void write(CharSequence sequence) {
        try {
            this.httpServletResponse.getWriter().append(sequence);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void write(byte[] array) {
        try {
            this.httpServletResponse.getOutputStream().write(array);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void setStatus(int sc) {
        this.httpServletResponse.setStatus(sc);
    }

    public void sendError(int sc, String msg) {
        try {
            if (msg == null) {
                this.httpServletResponse.sendError(sc);
            } else {
                this.httpServletResponse.sendError(sc, msg);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String encodeURL(CharSequence url) {
        Args.notNull((Object)url, (String)"url");
        if (url.length() > 0 && url.charAt(0) == '?') {
            String encoded = this.httpServletResponse.encodeURL("./" + ((Object)url).toString());
            if (encoded.startsWith("./")) {
                return encoded.substring(2);
            }
            return encoded;
        }
        return this.httpServletResponse.encodeURL(((Object)url).toString());
    }

    private String getAbsolutePrefix() {
        return "";
    }

    private String getAbsoluteURL(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        if (url.startsWith("/")) {
            return this.getAbsolutePrefix() + url;
        }
        HttpServletRequest httpServletRequest = this.webRequest.getContainerRequest();
        Charset charset = RequestUtils.getCharset((HttpServletRequest)httpServletRequest);
        Url current = this.webRequest.getClientUrl();
        Url append = Url.parse((String)url, (Charset)charset);
        current.concatSegments(append.getSegments());
        Url result = new Url(current.getSegments(), append.getQueryParameters());
        String path = result.toString();
        if (Strings.isEmpty((CharSequence)path)) {
            path = "/";
        }
        return Strings.join((String)"/", (String[])new String[]{this.getAbsolutePrefix(), httpServletRequest.getContextPath(), this.webRequest.getFilterPrefix(), path});
    }

    public String encodeRedirectURL(CharSequence url) {
        return this.httpServletResponse.encodeRedirectURL(((Object)url).toString());
    }

    public void sendRedirect(String url) {
        try {
            this.redirect = true;
            url = this.encodeRedirectURL(url);
            this.disableCaching();
            if (this.webRequest.isAjax()) {
                this.httpServletResponse.addHeader("Ajax-Location", url);
                this.httpServletResponse.getWriter().write("<ajax-response><redirect><![CDATA[" + url + "]]></redirect></ajax-response>");
                this.setContentType("text/xml;charset=" + this.webRequest.getContainerRequest().getCharacterEncoding());
                this.disableCaching();
            } else {
                this.httpServletResponse.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void flush() {
        try {
            this.httpServletResponse.flushBuffer();
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void reset() {
        super.reset();
        this.httpServletResponse.reset();
        this.redirect = false;
    }

    public HttpServletResponse getContainerResponse() {
        return this.httpServletResponse;
    }
}

