/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;

public abstract class AbstractClassResolver
implements IClassResolver {
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class<?> resolveClass(String className) throws ClassNotFoundException {
        if (className.startsWith("BuildVariablePromptBean")) {
            Long configurationId = Long.valueOf(StringUtils.substringAfter((String)className, (String)"_"));
            Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(configurationId);
            return configuration.getVariablePromptBeanClass();
        }
        if (className.startsWith("PromoteVariablePromptBean")) {
            Long buildId = Promotion.getBuildId(className);
            Build build = (Build)BuildManager.instance.load(buildId);
            String promotionName = Promotion.getName(className);
            Promotion promotion = build.getConfiguration().findPromotion(promotionName);
            if (promotion == null) {
                throw new QuickbuildException("Can not load promote option page for '" + promotionName + "' since it has been deleted.");
            }
            ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
            promotion = (Promotion)scriptEngine.installInterpolator(promotion);
            return promotion.getVariablePromptBeanClass(build);
        }
        Class<Object> clazz = this.classes.get(className);
        if (clazz == null) {
            if (className.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (className.equals("short")) {
                clazz = Short.TYPE;
            } else if (className.equals("int")) {
                clazz = Integer.TYPE;
            } else if (className.equals("long")) {
                clazz = Long.TYPE;
            } else if (className.equals("float")) {
                clazz = Float.TYPE;
            } else if (className.equals("double")) {
                clazz = Double.TYPE;
            } else if (className.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (className.equals("char")) {
                clazz = Character.TYPE;
            } else {
                Map<String, Class<?>> map = this.classes;
                synchronized (map) {
                    clazz = Class.forName(className, false, this.getClassLoader());
                    if (clazz == null) {
                        throw new ClassNotFoundException(className);
                    }
                }
                this.classes.put(className, clazz);
            }
        }
        return clazz;
    }

    protected abstract ClassLoader getClassLoader();

    public Iterator<URL> getResources(String name) {
        ArrayList<URL> resultList = new ArrayList<URL>();
        HashSet<URI> loadedFiles = new HashSet<URI>();
        try {
            Enumeration<URL> resources = Application.class.getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = Application.get().getClass().getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = this.getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            for (URI uri : loadedFiles) {
                resultList.add(uri.toURL());
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return resultList.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URI> loadedFiles) throws URISyntaxException {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                URI uri = url.toURI();
                if (loadedFiles.contains(uri)) continue;
                loadedFiles.add(uri);
            }
        }
    }
}

