/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import com.pmease.quickbuild.Context;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.RequestHandlerStack;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestListenerInterface {
    private static final Map<String, RequestListenerInterface> interfaces = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(RequestListenerInterface.class);
    private Method method;
    private final String name;
    private boolean includeRenderCount = true;
    private boolean renderPageAfterInvocation = true;
    final Class<? extends IRequestListener> listenerInterfaceClass;

    public static final RequestListenerInterface forName(String interfaceName) {
        return interfaces.get(interfaceName);
    }

    public RequestListenerInterface(Class<? extends IRequestListener> listenerInterfaceClass) {
        this.listenerInterfaceClass = listenerInterfaceClass;
        if (!IRequestListener.class.isAssignableFrom(listenerInterfaceClass)) {
            throw new IllegalArgumentException("Class " + listenerInterfaceClass + " must extend IRequestListener");
        }
        Method[] methods = listenerInterfaceClass.getMethods();
        if (methods.length == 1) {
            if (methods[0].getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Method " + methods[0] + " in interface " + listenerInterfaceClass + " cannot take any arguments");
            }
        } else {
            throw new IllegalArgumentException("Interface " + listenerInterfaceClass + " can have only one method");
        }
        this.method = methods[0];
        this.name = Classes.simpleName(listenerInterfaceClass);
        this.register();
    }

    public Class<? extends IRequestListener> getListenerInterfaceClass() {
        return this.listenerInterfaceClass;
    }

    public RequestListenerInterface setIncludeRenderCount(boolean includeRenderCount) {
        this.includeRenderCount = includeRenderCount;
        return this;
    }

    public boolean isIncludeRenderCount() {
        return this.includeRenderCount;
    }

    public RequestListenerInterface setRenderPageAfterInvocation(boolean renderPageAfterInvocation) {
        this.renderPageAfterInvocation = renderPageAfterInvocation;
        return this;
    }

    public boolean isRenderPageAfterInvocation() {
        return this.renderPageAfterInvocation;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(IRequestableComponent rcomponent) {
        Component component = (Component)rcomponent;
        Context.pushComponent(component);
        try {
            if (!component.canCallListenerInterface()) {
                log.info("component not enabled or visible; ignoring call. Component: " + component);
                throw new ListenerInvocationNotAllowedException(this, component, null, "Component rejected interface invocation");
            }
            this.internalInvoke(component, component);
        }
        finally {
            Context.popComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(IRequestableComponent rcomponent, Behavior behavior) {
        Component component = (Component)rcomponent;
        Context.pushComponent(component);
        try {
            if (!behavior.canCallListenerInterface(component)) {
                log.warn("behavior not enabled; ignore call. Behavior {} at component {}", (Object)behavior, (Object)component);
                throw new ListenerInvocationNotAllowedException(this, component, behavior, "Behavior rejected interface invocation");
            }
            this.internalInvoke(component, behavior);
        }
        finally {
            Context.popComponent();
        }
    }

    private void internalInvoke(Component component, Object target) {
        Boolean frozen = null;
        Page page = component.getPage();
        if (!page.isInitialized()) {
            page.internalInitialize();
        }
        try {
            this.method.invoke(target, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RequestHandlerStack.ReplaceHandlerException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof WicketRuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException("Method " + this.method.getName() + " of " + this.method.getDeclaringClass() + " targeted at " + target + " on component " + component + " threw an exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Method " + this.method.getName() + " of " + this.method.getDeclaringClass() + " targeted at " + target + " on component " + component + " threw an exception", (Throwable)e);
        }
        finally {
            if (frozen != null) {
                page.setFreezePageId(frozen.booleanValue());
            }
        }
    }

    public void register() {
        this.registerRequestListenerInterface(this);
    }

    public String toString() {
        return "[RequestListenerInterface name=" + this.name + ", method=" + this.method + "]";
    }

    private final void registerRequestListenerInterface(RequestListenerInterface requestListenerInterface) {
        RequestListenerInterface existingInterface = RequestListenerInterface.forName(requestListenerInterface.getName());
        if (existingInterface != null && existingInterface.getMethod() != requestListenerInterface.getMethod()) {
            throw new IllegalStateException("Cannot register listener interface " + requestListenerInterface + " because it conflicts with the already registered interface " + existingInterface);
        }
        interfaces.put(requestListenerInterface.getName(), requestListenerInterface);
        log.info("registered listener interface " + this);
    }

    public static Collection<RequestListenerInterface> getRegisteredInterfaces() {
        return Collections.unmodifiableCollection(interfaces.values());
    }
}

