/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingMapper
extends MapperWrapper {
    private transient Map realClassCache;

    public CachingMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public CachingMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
        this.readResolve();
    }

    public Class realClass(String elementName) {
        Class clazz = (Class)this.realClassCache.get(elementName);
        if (clazz == null) {
            clazz = super.realClass(elementName);
            this.realClassCache.put(elementName, clazz);
        }
        return clazz;
    }

    private Object readResolve() {
        this.realClassCache = new ConcurrentHashMap();
        return this;
    }
}

