/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source.diff;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.web.page.source.diff.DiffMatchPatch;
import java.util.LinkedList;
import java.util.List;

public class SourceDifference {
    private final String text1;
    private final String text2;
    public static final String SEPARATOR = "\n";
    List<LineInfo> originals = Lists.newArrayList();
    List<LineInfo> reviseds = Lists.newArrayList();
    int oCounter = 0;
    int rCounter = 0;

    public SourceDifference(String[] oldLines, String[] curLines) {
        this.text1 = Joiner.on((String)SEPARATOR).join((Object[])oldLines);
        this.text2 = Joiner.on((String)SEPARATOR).join((Object[])curLines);
    }

    void generateLineInfos() {
        DiffMatchPatch dmp = new DiffMatchPatch();
        DiffMatchPatch.LinesToCharsResult tmp = dmp.diff_linesToChars(this.text1, this.text2);
        LinkedList<DiffMatchPatch.Diff> diffs = dmp.diff_main(tmp.chars1, tmp.chars2, false);
        dmp.diff_charsToLines(diffs, tmp.lineArray);
        DiffMatchPatch.Diff diff = diffs.poll();
        while (diff != null) {
            if (diff.operation == DiffMatchPatch.Operation.EQUAL) {
                this.processDiff(diff, DiffStatus.EQUAL);
                diff = diffs.poll();
                continue;
            }
            if (diff.operation == DiffMatchPatch.Operation.DELETE) {
                DiffMatchPatch.Diff next = diffs.poll();
                if (next != null && next.operation == DiffMatchPatch.Operation.INSERT) {
                    this.processModify(diff, next);
                    diff = diffs.poll();
                    continue;
                }
                this.processDiff(diff, DiffStatus.DELETE);
                diff = next;
                continue;
            }
            this.processDiff(diff, DiffStatus.INSERT);
            diff = diffs.poll();
        }
    }

    void processDiff(DiffMatchPatch.Diff diff, DiffStatus status) {
        String[] lines = SourceDifference.getDiffLines(diff);
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            boolean first = i == 0;
            boolean last = i + 1 == size;
            LineInfo orig = new LineInfo();
            LineInfo rev = new LineInfo();
            orig.first = first;
            orig.last = last;
            orig.status = status;
            rev.first = first;
            rev.last = last;
            rev.status = status;
            if (status == DiffStatus.EQUAL) {
                orig.original = this.oCounter;
                orig.revised = this.rCounter;
                rev.original = this.oCounter++;
                rev.revised = this.rCounter++;
                orig.text = lines[i];
                rev.text = lines[i];
            } else if (status == DiffStatus.INSERT) {
                orig.original = -1;
                orig.revised = this.rCounter;
                rev.original = -1;
                rev.revised = this.rCounter++;
                rev.text = lines[i];
            } else if (status == DiffStatus.DELETE) {
                orig.original = this.oCounter;
                orig.revised = -1;
                orig.text = lines[i];
                rev.original = this.oCounter++;
                rev.revised = -1;
            }
            this.originals.add(orig);
            this.reviseds.add(rev);
        }
    }

    void processModify(DiffMatchPatch.Diff del, DiffMatchPatch.Diff ins) {
        String[] dlines = SourceDifference.getDiffLines(del);
        String[] ilines = SourceDifference.getDiffLines(ins);
        int size = Math.max(dlines.length, ilines.length);
        for (int i = 0; i < size; ++i) {
            boolean first = i == 0;
            boolean last = i + 1 == size;
            LineInfo orig = new LineInfo();
            orig.first = first;
            orig.last = last;
            LineInfo rev = new LineInfo(orig);
            if (i < dlines.length && i < ilines.length) {
                orig.original = this.oCounter;
                orig.revised = this.rCounter;
                orig.text = dlines[i];
                orig.status = DiffStatus.MDELETE;
                rev.original = this.oCounter++;
                rev.revised = this.rCounter++;
                rev.text = ilines[i];
                rev.status = DiffStatus.MINSERT;
            } else if (i < dlines.length) {
                orig.original = this.oCounter;
                orig.revised = -1;
                orig.text = dlines[i];
                rev.original = this.oCounter++;
                rev.revised = -1;
            } else {
                orig.original = -1;
                orig.revised = this.rCounter;
                orig.status = DiffStatus.MDELETE;
                rev.original = -1;
                rev.revised = this.rCounter++;
                rev.status = DiffStatus.MINSERT;
                rev.text = ilines[i];
            }
            this.originals.add(orig);
            this.reviseds.add(rev);
        }
    }

    static String[] getDiffLines(DiffMatchPatch.Diff diff) {
        Preconditions.checkNotNull((Object)diff, (Object)"We should not get an null diff, this must be a bug!");
        String text = diff.text;
        int pos = text.lastIndexOf(SEPARATOR);
        if (pos + 1 == text.length()) {
            text = text.substring(0, pos);
        }
        Iterable it = Splitter.on((String)SEPARATOR).split((CharSequence)diff.text);
        return (String[])Iterables.toArray((Iterable)it, String.class);
    }

    public static class LineInfo {
        public int original;
        public int revised;
        public DiffStatus status;
        public boolean first;
        public boolean last;
        public String text;

        LineInfo() {
        }

        LineInfo(LineInfo other) {
            this.original = other.original;
            this.revised = other.revised;
            this.status = other.status;
            this.first = other.first;
            this.last = other.last;
            this.text = other.text;
        }

        public int getOriginal() {
            return this.original;
        }

        public int getRevised() {
            return this.revised;
        }

        public String getStatus() {
            return this.status.name();
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isLast() {
            return this.last;
        }

        public String getText() {
            return this.text;
        }

        public String getActionSymbol() {
            if (this.status == DiffStatus.INSERT || this.status == DiffStatus.MINSERT) {
                return "+";
            }
            if (this.status == DiffStatus.DELETE || this.status == DiffStatus.MDELETE) {
                return "-";
            }
            return "";
        }
    }

    public static enum DiffStatus {
        EQUAL,
        INSERT,
        DELETE,
        MINSERT,
        MDELETE;

    }
}

