/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source.diff;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.web.page.source.diff.DiffMatchPatch;
import com.pmease.quickbuild.web.page.source.diff.SourceDifference;
import java.util.LinkedList;
import java.util.List;

public class DifferenceBySingleColumn {
    private final String text1;
    private final String text2;
    private int oCounter = 0;
    private int rCounter = 0;
    public List<SourceDifference.LineInfo> lines = Lists.newArrayList();
    static String SEPARATOR = "<br />\n";

    public DifferenceBySingleColumn(String text1, String text2) {
        this.text1 = text1;
        this.text2 = text2;
    }

    public DifferenceBySingleColumn(String[] oldLines, String[] newLines) {
        this(Joiner.on((String)"\n").join((Object[])oldLines), Joiner.on((String)"\n").join((Object[])newLines));
    }

    public void generateLineInfos() {
        DiffMatchPatch dmp = new DiffMatchPatch();
        DiffMatchPatch.LinesToCharsResult tmp = dmp.diff_linesToChars(this.text1, this.text2);
        LinkedList<DiffMatchPatch.Diff> diffs = dmp.diff_main(tmp.chars1, tmp.chars2, false);
        dmp.diff_charsToLines(diffs, tmp.lineArray);
        DiffMatchPatch.Diff diff = diffs.poll();
        while (diff != null) {
            if (diff.operation == DiffMatchPatch.Operation.EQUAL) {
                this.processDiff(diff, SourceDifference.DiffStatus.EQUAL);
                diff = diffs.poll();
                continue;
            }
            if (diff.operation == DiffMatchPatch.Operation.DELETE) {
                DiffMatchPatch.Diff next = diffs.poll();
                if (next != null && next.operation == DiffMatchPatch.Operation.INSERT) {
                    this.processModify(diff, next);
                    diff = diffs.poll();
                    continue;
                }
                this.processDiff(diff, SourceDifference.DiffStatus.DELETE);
                diff = next;
                continue;
            }
            this.processDiff(diff, SourceDifference.DiffStatus.INSERT);
            diff = diffs.poll();
        }
    }

    void processDiff(DiffMatchPatch.Diff diff, SourceDifference.DiffStatus status) {
        String[] lines = this.getDiffLines(diff);
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            SourceDifference.LineInfo line = new SourceDifference.LineInfo();
            line.first = i == 0;
            line.last = i + 1 == size;
            line.status = status;
            line.text = lines[i];
            if (status == SourceDifference.DiffStatus.EQUAL) {
                line.original = this.oCounter++;
                line.revised = this.rCounter++;
            } else if (status == SourceDifference.DiffStatus.INSERT) {
                line.original = -1;
                line.revised = this.rCounter++;
            } else if (status == SourceDifference.DiffStatus.DELETE) {
                line.original = this.oCounter++;
                line.revised = -1;
            }
            this.lines.add(line);
        }
    }

    void processModify(DiffMatchPatch.Diff del, DiffMatchPatch.Diff ins) {
        SourceDifference.LineInfo line;
        int i;
        String[] dlines = this.getDiffLines(del);
        String[] ilines = this.getDiffLines(ins);
        for (i = 0; i < dlines.length; ++i) {
            line = new SourceDifference.LineInfo();
            line.original = this.oCounter;
            line.revised = -1;
            line.first = i == 0;
            line.status = SourceDifference.DiffStatus.MDELETE;
            line.text = dlines[i];
            this.lines.add(line);
            ++this.oCounter;
        }
        for (i = 0; i < ilines.length; ++i) {
            line = new SourceDifference.LineInfo();
            line.original = -1;
            line.revised = this.rCounter;
            line.last = i + 1 == ilines.length;
            line.status = SourceDifference.DiffStatus.MINSERT;
            line.text = ilines[i];
            this.lines.add(line);
            ++this.rCounter;
        }
    }

    String[] getDiffLines(DiffMatchPatch.Diff diff) {
        Preconditions.checkNotNull((Object)diff, (Object)"We should never get an null diff here, this must be a bug!");
        String text = diff.text;
        int pos = text.lastIndexOf("\n");
        if (pos + 1 == text.length()) {
            text = text.substring(0, pos);
        }
        Iterable it = Splitter.on((String)"\n").split((CharSequence)text);
        return (String[])Iterables.toArray((Iterable)it, String.class);
    }
}

