/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source.diff;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.web.page.source.diff.DiffBlock;
import com.pmease.quickbuild.web.page.source.diff.DiffChunk;
import com.pmease.quickbuild.web.page.source.diff.DiffLine;
import com.pmease.quickbuild.web.page.source.diff.DiffMatchPatch;
import java.util.LinkedList;
import java.util.List;

public class Difference {
    private List<DiffBlock> blocks = Lists.newArrayList();
    private int oCounter = 0;
    private int rCounter = 0;

    public void diff(String[] origLines, String[] revisedLines) {
        String text1 = Joiner.on((String)"\n").join((Object[])origLines);
        String text2 = Joiner.on((String)"\n").join((Object[])revisedLines);
        DiffMatchPatch dmp = new DiffMatchPatch();
        DiffMatchPatch.LinesToCharsResult tmp = dmp.diff_linesToChars(text1, text2);
        LinkedList<DiffMatchPatch.Diff> diffs = dmp.diff_main(tmp.chars1, tmp.chars2, false);
        dmp.diff_charsToLines(diffs, tmp.lineArray);
        DiffMatchPatch.Diff diff = diffs.poll();
        while (diff != null) {
            DiffBlock block = new DiffBlock();
            this.blocks.add(block);
            if (diff.operation == DiffMatchPatch.Operation.DELETE) {
                DiffMatchPatch.Diff next = diffs.poll();
                if (next != null && next.operation == DiffMatchPatch.Operation.INSERT) {
                    this.processModify(diff, next, block);
                    diff = diffs.poll();
                    continue;
                }
                block.type = DiffBlock.BlockType.DELETE;
                this.processDiff(diff, block);
                diff = next;
                continue;
            }
            if (diff.operation == DiffMatchPatch.Operation.EQUAL) {
                block.type = DiffBlock.BlockType.EQUAL;
                this.processDiff(diff, block);
                diff = diffs.poll();
                continue;
            }
            if (diff.operation != DiffMatchPatch.Operation.INSERT) continue;
            block.type = DiffBlock.BlockType.INSERT;
            this.processDiff(diff, block);
            diff = diffs.poll();
        }
    }

    public List<DiffBlock> getBlocks() {
        return this.blocks;
    }

    void processModify(DiffMatchPatch.Diff del, DiffMatchPatch.Diff ins, DiffBlock block) {
        block.type = DiffBlock.BlockType.DELETE;
        this.processDiff(del, block);
        block.type = DiffBlock.BlockType.INSERT;
        this.processDiff(ins, block);
        block.type = DiffBlock.BlockType.MODIFY;
    }

    void processDiff(DiffMatchPatch.Diff diff, DiffBlock block) {
        Iterable<String> iterable = this.getDiffLines(diff);
        int size = Iterables.size(iterable);
        if (size <= 0) {
            return;
        }
        DiffChunk original = new DiffChunk();
        DiffChunk revised = new DiffChunk();
        original.first = this.oCounter;
        original.length = size;
        revised.first = this.rCounter;
        revised.length = size;
        DiffBlock.BlockType type = block.type;
        if (type == DiffBlock.BlockType.EQUAL) {
            block.original = original;
            block.revised = revised;
        } else if (type == DiffBlock.BlockType.DELETE) {
            block.original = original;
        } else if (type == DiffBlock.BlockType.INSERT) {
            block.revised = revised;
        }
        for (String text : iterable) {
            DiffLine line;
            if (type == DiffBlock.BlockType.EQUAL || type == DiffBlock.BlockType.DELETE) {
                line = new DiffLine();
                line.lineNo = this.oCounter++;
                line.text = text;
                original.addLine(line);
            }
            if (type != DiffBlock.BlockType.EQUAL && type != DiffBlock.BlockType.INSERT) continue;
            line = new DiffLine();
            line.lineNo = this.rCounter++;
            line.text = text;
            revised.addLine(line);
        }
    }

    Iterable<String> getDiffLines(DiffMatchPatch.Diff diff) {
        Preconditions.checkNotNull((Object)diff, (Object)"We should never get an null diff here, this must be a bug!");
        String text = diff.text;
        int pos = text.lastIndexOf("\n");
        if (pos + 1 == text.length()) {
            text = text.substring(0, pos);
        }
        return Splitter.on((String)"\n").split((CharSequence)text);
    }
}

