/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source;

import com.google.common.base.Strings;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.source.Block;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SourceViewPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private Block[] blocks;
    private int startLine;
    private String title;
    private String sourceType;
    private String[] sourceLines;
    private int toLine;
    public static final String BUILD_ID = "build";
    public static final String REPOSITORY = "repository";
    public static final String FILE_PATH = "file";
    public static final String FILE_EDITION = "edition";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readSource(PageParameters params) {
        Long buildId = params.get(BUILD_ID).toLong();
        String repositoryName = params.get(REPOSITORY).toString();
        String filePath = params.get(FILE_PATH).toString();
        String fileEdition = params.get(FILE_EDITION).toString();
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(buildId);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.VIEW_SOURCE.name())) {
            throw new AccessDeniedException("You have no permission to access the source code for configuration " + build.getConfiguration().getPathName());
        }
        try {
            Context.push(build);
            Repository<?> repository = build.getRepository(repositoryName);
            if (repository == null) {
                throw new QuickbuildException("Repository '" + repositoryName + "' is not found.");
            }
            SourceViewSupport<?> sourceViewSupport = repository.getSourceViewSupport();
            if (sourceViewSupport == null) {
                throw new QuickbuildException("Source view of repository '" + repositoryName + "' is not supported.");
            }
            List<String> sourceLines = Strings.isNullOrEmpty((String)fileEdition) ? sourceViewSupport.readSourceByRevision(filePath, repository.getRevision()) : sourceViewSupport.readSourceByEdition(filePath, fileEdition);
            if (sourceLines == null) {
                sourceLines = new ArrayList<String>();
            }
            String[] stringArray = sourceLines.toArray(new String[sourceLines.size()]);
            return stringArray;
        }
        finally {
            Context.pop();
        }
    }

    static String appendUrl(String key, String value) {
        try {
            return new StringBuffer().append(key).append("=").append(URLEncoder.encode(value, "UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static PageParameters paramsFor(Long buildId, String repository, String filePath) {
        return SourceViewPage.paramsFor(buildId, repository, filePath, null);
    }

    public static PageParameters paramsFor(Long buildId, String repository, String filePath, String edition) {
        PageParameters params = new PageParameters();
        params.add(BUILD_ID, (Object)buildId);
        params.add(REPOSITORY, (Object)repository);
        params.add(FILE_PATH, (Object)filePath);
        if (!Strings.isNullOrEmpty((String)edition)) {
            params.add(FILE_EDITION, (Object)edition);
        }
        return params;
    }

    public static String url4Revision(Long buildId, String repository, String filePath) {
        RequestCycle cycle = RequestCycle.get();
        if (cycle == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(StringUtils.stripEnd((String)Quickbuild.getInstance().getUrl(), (String)"/")).append("/source/view?").append(SourceViewPage.appendUrl(BUILD_ID, String.valueOf(buildId))).append("&").append(SourceViewPage.appendUrl(REPOSITORY, repository)).append("&").append(SourceViewPage.appendUrl(FILE_PATH, filePath));
            return sb.toString();
        }
        return ((Object)cycle.urlFor(SourceViewPage.class, SourceViewPage.paramsFor(buildId, repository, filePath))).toString();
    }

    public static String url4Edition(Long buildId, String repository, String filePath, String edition) {
        RequestCycle cycle = RequestCycle.get();
        if (cycle == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(SourceViewPage.url4Revision(buildId, repository, filePath));
            sb.append("&").append(SourceViewPage.appendUrl(FILE_EDITION, edition));
            return sb.toString();
        }
        return ((Object)cycle.urlFor(SourceViewPage.class, SourceViewPage.paramsFor(buildId, repository, filePath, edition))).toString();
    }

    public SourceViewPage(PageParameters params) {
        this(params.get(FILE_PATH).toString(), FilenameUtils.getExtension((String)params.get(FILE_PATH).toString()), SourceViewPage.readSource(params));
    }

    public SourceViewPage(String title, String sourceType, String[] sourceLines) {
        this(title, sourceType, sourceLines, null);
    }

    public SourceViewPage(String title, String sourceType, String[] sourceLines, Block[] blocks) {
        this(title, sourceType, sourceLines, blocks, blocks == null || blocks.length == 0 ? 0 : blocks[0].getStartLine());
    }

    public SourceViewPage(String title, String sourceType, String[] sourceLines, Block[] blocks, int toLine) {
        this.title = title;
        this.blocks = blocks;
        if (this.blocks == null) {
            this.blocks = new Block[0];
        }
        Arrays.sort(this.blocks);
        this.sourceLines = sourceLines;
        this.sourceType = sourceType;
        this.toLine = toLine;
    }

    @Override
    protected void onInitialize() {
        String[] lines;
        super.onInitialize();
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void beforeRender(Component c) {
                c.getResponse().write((CharSequence)"<div id='loadingWarning' style='text-align: center;background-color: #fff;border: 5px solid #c6c6c6;padding: 10px;position: absolute;top: 37%;left: 35%;z-index: 1000;width: 12em;color: #868686;font-family: arial, sans-serif;font-size: 20px;'>LOADING...</div>");
            }
        }});
        this.add(new Component[]{new Label("sourcetitle", this.title)});
        for (int i = 0; i < this.sourceLines.length; ++i) {
            this.sourceLines[i] = this.sourceLines[i].trim().length() == 0 ? " " : StringUtils.stripEnd((String)this.sourceLines[i], (String)" \n\t\r");
        }
        Renderer renderer = XhtmlRendererFactory.getRenderer((String)this.sourceType);
        if (renderer != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(StringUtils.join((Object[])this.sourceLines, (String)"\n").getBytes("UTF-8"));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                renderer.highlight("", (InputStream)is, (OutputStream)os, "UTF-8", true);
                String highlighted = os.toString("UTF-8");
                highlighted = highlighted.substring(highlighted.indexOf("\n") + 1);
                lines = StringUtils.splitByWholeSeparator((String)highlighted, (String)"<br />\n");
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].trim().length() != 0) continue;
                    lines[i] = "&nbsp;";
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            lines = new String[this.sourceLines.length];
            for (int i = 0; i < this.sourceLines.length; ++i) {
                lines[i] = StringEscapeUtils.escapeHtml((String)this.sourceLines[i]);
                lines[i] = StringUtils.replace((String)lines[i], (String)" ", (String)"&nbsp;");
                lines[i] = StringUtils.replace((String)lines[i], (String)"\t", (String)"&nbsp;&nbsp;&nbsp;&nbsp;");
            }
        }
        this.add(new Component[]{new Label("sources", this.renderContent(lines, this.blocks)).setEscapeModelStrings(false)});
        this.startLine = this.toLine > 0 ? this.toLine : (this.blocks.length > 0 ? this.blocks[0].getStartLine() : 1);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderOnLoadJavaScript("window.location.href='#" + this.startLine + "';");
    }

    protected static String escapeMessage(String from) {
        return StringUtils.replace((String)from, (String)"\"", (String)"&quot;");
    }

    protected int renderBlock(int lineno, StringBuffer sb, String[] lines, Block each) {
        int startLine = each.getStartLine();
        int endLine = each.getEndLine();
        if (startLine < 1) {
            startLine = 1;
        }
        if (endLine < 1) {
            endLine = 1;
        }
        while (lineno < startLine && lineno <= lines.length) {
            sb.append("<tr>");
            sb.append("<td class='line-no'><a name='").append(lineno).append("'>").append(lineno).append("</td>");
            sb.append("<td class='line-content'>").append(lines[lineno - 1]).append("</td>");
            sb.append("</tr>");
            ++lineno;
        }
        String color = each.getColor();
        if (StringUtils.isEmpty((String)color)) {
            color = "#666666";
        } else if (color.charAt(0) != '#') {
            color = "#" + color;
        }
        String message = each.getMessage();
        message = SourceViewPage.escapeMessage(message);
        while (lineno <= endLine && lineno <= lines.length) {
            sb.append("<tr>");
            sb.append("<td class='line-no'><a name='").append(lineno).append("'>").append(lineno).append("</td>");
            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>");
            sb.append("<span");
            if (!StringUtils.isEmpty((String)message)) {
                sb.append(" class='with-msg' ").append("title=\"").append(message).append("\"");
            }
            sb.append(">").append(lines[lineno - 1]).append("</span>");
            sb.append("</td></tr>");
            ++lineno;
        }
        return lineno;
    }

    protected String renderContent(String[] lines, Block[] blocks) {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        sb.append("<table>");
        if (blocks != null && blocks.length > 0) {
            for (Block each : blocks) {
                i = this.renderBlock(i, sb, lines, each);
            }
        }
        while (i <= lines.length) {
            sb.append("<tr>");
            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
            sb.append("</tr>");
            ++i;
        }
        sb.append("</table>");
        return sb.toString();
    }

    protected void renderAsLabel(String[] lines, Block[] blocks) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        int lineNo = 0;
        for (String line : lines) {
            block17: {
                block18: {
                    String onclick;
                    block16: {
                        ++lineNo;
                        buffer.append("<tr><td align='right' nowrap class='line-no'>");
                        String message = null;
                        for (Block block : this.blocks) {
                            if (lineNo != block.getStartLine()) continue;
                            message = StringUtils.replace((String)block.getMessage(), (String)"'", (String)"&rsquo;");
                            break;
                        }
                        if (message != null) {
                            buffer.append("<img src='/images/tiny-warn.gif' style='cursor:pointer' title='" + message + "'></img> ");
                        }
                        if (lineNo != 1) break block16;
                        if (this.blocks.length <= 0) break block17;
                        onclick = null;
                        if (this.blocks[0].getStartLine() != 1) {
                            onclick = "self.location.hash = '#" + this.blocks[0].getStartLine() + "';";
                        } else if (this.blocks.length > 1) {
                            onclick = "self.location.hash = '#" + this.blocks[1].getStartLine() + "';";
                        }
                        if (onclick != null) {
                            buffer.append("<img src='/images/tiny-down.gif' style='cursor:pointer' title='next block' onclick=\"" + onclick + "\"></img> ");
                        }
                        break block17;
                    }
                    if (lineNo != lines.length) break block18;
                    if (this.blocks.length <= 0) break block17;
                    onclick = null;
                    if (this.blocks[this.blocks.length - 1].getStartLine() != lineNo) {
                        onclick = "self.location.hash = '#" + this.blocks[this.blocks.length - 1].getStartLine() + "';";
                    } else if (this.blocks.length > 1) {
                        onclick = "self.location.hash = '#" + this.blocks[this.blocks.length - 2].getStartLine() + "';";
                    }
                    if (onclick != null) {
                        buffer.append("<img src='/images/tiny-up.gif' style='cursor:pointer' title='previous block' onclick=\"" + onclick + "\"></img> ");
                    }
                    break block17;
                }
                for (int i = 0; i < this.blocks.length; ++i) {
                    if (lineNo != this.blocks[i].getStartLine()) continue;
                    if (i + 1 < this.blocks.length) {
                        buffer.append("<img src='/images/tiny-down.gif' style='cursor:pointer' title='next block' onclick=\"self.location.hash = '#" + this.blocks[i + 1].getStartLine() + "';\"></img> ");
                    }
                    if (i == 0) break;
                    buffer.append("<img src='/images/tiny-up.gif' style='cursor:pointer' title='previous block' onclick=\"self.location.hash = '#" + this.blocks[i - 1].getStartLine() + "';\"></img> ");
                    break;
                }
            }
            buffer.append("<a name='" + lineNo + "'>");
            buffer.append(lineNo);
            buffer.append("</a></td><td class='line'>");
            String color = null;
            for (Block block : this.blocks) {
                if (lineNo < block.getStartLine() || lineNo > block.getEndLine()) continue;
                color = block.getColor();
                break;
            }
            if (color != null) {
                buffer.append("<td class='line-content colored' style='background:#" + color + "'>");
            } else {
                buffer.append("<td class='line-content'>");
            }
            buffer.append(line);
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        this.add(new Component[]{new Label("body", buffer.toString())});
        this.get("body").setEscapeModelStrings(false);
    }
}

