/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.extensionpoint.SourceDiffRenderer;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.source.DefaultSourceDiffPanel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SourceDiffPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private final String sourceTitle;
    private final String sourceType;
    private final String[] revised;
    private final String[] original;
    public static final String BUILD_ID = "build";
    public static final String PREVIOUS_BUILD_ID = "previous_build";
    public static final String REPOSITORY = "repository";
    public static final String FILE_PATH = "file";
    public static final String FILE_EDITION = "edition";
    public static final String PREVIOUS_EDITION = "previous_edition";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readSource(Long buildId, String repositoryName, String filePath, String fileEdition) {
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(buildId);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.VIEW_SOURCE.name())) {
            throw new AccessDeniedException("You have no permission to access the source code for configuration " + build.getConfiguration().getPathName());
        }
        try {
            Context.push(build);
            Repository<?> repository = build.getRepository(repositoryName);
            if (repository == null) {
                throw new QuickbuildException("Repository '" + repositoryName + "' is not found.");
            }
            SourceViewSupport<?> sourceViewSupport = repository.getSourceViewSupport();
            if (sourceViewSupport == null) {
                throw new QuickbuildException("Source view of repository '" + repositoryName + "' is not supported.");
            }
            List<String> sourceLines = Strings.isNullOrEmpty((String)fileEdition) ? sourceViewSupport.readSourceByRevision(filePath, repository.getRevision()) : sourceViewSupport.readSourceByEdition(filePath, fileEdition);
            if (sourceLines == null) {
                sourceLines = new ArrayList<String>();
            }
            String[] stringArray = (String[])Iterables.toArray(sourceLines, String.class);
            return stringArray;
        }
        finally {
            Context.pop();
        }
    }

    static String appendUrl(String key, String value) {
        try {
            return new StringBuffer().append(key).append("=").append(URLEncoder.encode(value, "UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static PageParameters paramsFor(Long buildId, String filePath, String repository, String edition, String previousEdition) {
        PageParameters params = new PageParameters();
        params.add(BUILD_ID, (Object)buildId);
        params.add(FILE_PATH, (Object)filePath);
        params.add(FILE_EDITION, (Object)edition);
        params.add(PREVIOUS_EDITION, (Object)previousEdition);
        params.add(REPOSITORY, (Object)repository);
        return params;
    }

    public static PageParameters paramsFor(Long buildId, Long previousBuildId, String repository, String filePath) {
        PageParameters params = new PageParameters();
        params.add(BUILD_ID, (Object)buildId);
        params.add(PREVIOUS_BUILD_ID, (Object)previousBuildId);
        params.add(REPOSITORY, (Object)repository);
        params.add(FILE_PATH, (Object)filePath);
        return params;
    }

    public static String url4Edition(Long buildId, String filePath, String repository, String edition, String previousEdition) {
        RequestCycle cycle = RequestCycle.get();
        if (cycle == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(StringUtils.stripEnd((String)Quickbuild.getInstance().getUrl(), (String)"/")).append("/source/diff?").append(BUILD_ID).append("=").append(buildId).append("&").append(SourceDiffPage.appendUrl(REPOSITORY, repository)).append("&").append(SourceDiffPage.appendUrl(FILE_PATH, filePath)).append("&").append(SourceDiffPage.appendUrl(FILE_EDITION, edition)).append("&").append(SourceDiffPage.appendUrl(PREVIOUS_EDITION, previousEdition));
            return sb.toString();
        }
        return ((Object)cycle.urlFor(SourceDiffPage.class, SourceDiffPage.paramsFor(buildId, filePath, repository, edition, previousEdition))).toString();
    }

    public static String url4Revision(Long buildId, Long previousBuildId, String repository, String filePath) {
        RequestCycle cycle = RequestCycle.get();
        if (cycle == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(StringUtils.stripEnd((String)Quickbuild.getInstance().getUrl(), (String)"/")).append("/source/diff?").append(BUILD_ID).append("=").append(buildId).append("&").append(SourceDiffPage.appendUrl(PREVIOUS_BUILD_ID, String.valueOf(previousBuildId))).append("&").append(SourceDiffPage.appendUrl(REPOSITORY, repository)).append("&").append(SourceDiffPage.appendUrl(FILE_PATH, filePath));
            return sb.toString();
        }
        return ((Object)cycle.urlFor(SourceDiffPage.class, SourceDiffPage.paramsFor(buildId, previousBuildId, repository, filePath))).toString();
    }

    public SourceDiffPage(PageParameters params) {
        String filePath = params.get(FILE_PATH).toString();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filePath) ? 1 : 0) != 0, (Object)"file_path must be specified.");
        long buildId = params.get(BUILD_ID).toLong(0L);
        Preconditions.checkArgument((buildId > 0L ? 1 : 0) != 0, (Object)"build_id must be specified.");
        String repository = params.get(REPOSITORY).toString(null);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repository) ? 1 : 0) != 0, (Object)"repository_name must be specified.");
        String edition = params.get(FILE_EDITION).toString(null);
        long previousBuildId = params.get(PREVIOUS_BUILD_ID).toLong(0L);
        String previousEdition = params.get(PREVIOUS_EDITION).toString(null);
        if (previousBuildId == 0L) {
            previousBuildId = buildId;
        }
        this.sourceTitle = filePath;
        this.revised = SourceDiffPage.readSource(buildId, repository, filePath, edition);
        this.original = SourceDiffPage.readSource(previousBuildId, repository, filePath, previousEdition);
        this.sourceType = FilenameUtils.getExtension((String)filePath).toString();
    }

    public SourceDiffPage(String title, String sourceType, String[] revised, String[] original) {
        this.sourceTitle = title;
        this.sourceType = sourceType;
        this.revised = revised;
        this.original = original;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createContent("diffContent")});
    }

    protected Component createContent(String id) {
        List<SourceDiffRenderer> list = PluginManager.instance.getExtensions(SourceDiffRenderer.class);
        if (list == null || list.isEmpty()) {
            return new DefaultSourceDiffPanel(id, this.sourceTitle, this.sourceType, this.revised, this.original);
        }
        try {
            SourceDiffRenderer r = (SourceDiffRenderer)list.get(0).getClass().newInstance();
            return r.render(id, this.sourceTitle, this.sourceType, this.revised, this.original);
        }
        catch (InstantiationException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }
}

