/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.source;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.web.page.source.diff.DiffBlock;
import com.pmease.quickbuild.web.page.source.diff.DiffChunk;
import com.pmease.quickbuild.web.page.source.diff.DiffLine;
import com.pmease.quickbuild.web.page.source.diff.Difference;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public class DefaultSourceDiffPanel
extends Panel {
    private final String title;
    private final String sourceType;
    private final String[] revised;
    private final String[] original;
    private int startBlock = 1;

    public DefaultSourceDiffPanel(String id, String title, String sourceType, String[] revised, String[] original) {
        super(id);
        this.title = title;
        this.sourceType = sourceType;
        this.revised = revised;
        this.original = original;
        this.setRenderBodyOnly(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void beforeRender(Component c) {
                c.getResponse().write((CharSequence)"<div id='loadingWarning' style='text-align: center;background-color: #fff;border: 5px solid #c6c6c6;padding: 10px;position: absolute;top: 37%;left: 35%;z-index: 1000;width: 12em;color: #868686;font-family: tahoma, verdana, arial, sans-serif;font-size: 20px;'>LOADING...</div>");
            }
        }});
        this.add(new Component[]{this.createTitleBar("sourcetitle", this.title)});
        this.add(new Component[]{this.createContent("sources", this.sourceType, this.revised, this.original)});
    }

    protected Component createTitleBar(String id, String title) {
        return new Label(id, title);
    }

    public Component createContent(String id, String sourceType, String[] revised, String[] original) {
        Label label = new Label(id, this.renderContent(sourceType, revised, original)){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                response.renderOnLoadJavaScript("window.location.href='#block-" + DefaultSourceDiffPanel.this.startBlock + "';");
            }
        };
        return label.setEscapeModelStrings(false);
    }

    protected String renderContent(String sourceType, String[] revised, String[] original) {
        return this.singleColumnContent(sourceType, original, revised);
    }

    protected String singleColumnContent(String sourceType, String[] originalLines, String[] revisedLines) {
        String[] text2;
        String[] text1;
        long start = System.currentTimeMillis();
        Renderer renderer = XhtmlRendererFactory.getRenderer((String)sourceType);
        if (renderer == null) {
            text1 = this.renderAsText(originalLines);
            text2 = this.renderAsText(revisedLines);
        } else {
            text1 = this.renderAsHtml(Joiner.on((String)"\n").join((Object[])originalLines), renderer);
            text2 = this.renderAsHtml(Joiner.on((String)"\n").join((Object[])revisedLines), renderer);
        }
        Difference difference = new Difference();
        difference.diff(text1, text2);
        List<DiffBlock> blocks = difference.getBlocks();
        StringBuffer sb = new StringBuffer();
        sb.append("<div class='source-table-wrapper'><table>");
        for (int i = 0; i < blocks.size(); ++i) {
            DiffBlock block = blocks.get(i);
            if (block.getType() != DiffBlock.BlockType.EQUAL && this.startBlock == 0) {
                this.startBlock = i;
            }
            sb.append(this.renderBlock(i, blocks.get(i), originalLines, revisedLines));
        }
        sb.append("</table></div>");
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Rendering diff content to html cost " + (System.currentTimeMillis() - start) + " millis");
        }
        return sb.toString();
    }

    String simpleProcessSourceLine(String line) {
        EscapeTool escape = new EscapeTool();
        String result = escape.html((Object)line);
        result = StringUtils.replace((String)result, (String)"\t", (String)"    ");
        return new StringBuffer().append("<pre>").append("<b>").append(result).append("</b></pre>").toString();
    }

    String[] renderAsText(String[] lines) {
        String[] result = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            result[i] = this.simpleProcessSourceLine(lines[i]);
        }
        return result;
    }

    String renderBlock(int blockNum, DiffBlock block, String[] originalLines, String[] revisedLines) {
        DiffLine line1;
        int i;
        DiffChunk orig = block.getOriginal();
        DiffChunk revised = block.getRevised();
        ArrayList rows = Lists.newArrayList();
        if (block.getType() == DiffBlock.BlockType.EQUAL) {
            for (i = 0; i < orig.getLength(); ++i) {
                line1 = orig.getLines().get(i);
                DiffLine line2 = revised.getLines().get(i);
                SingleLine line = new SingleLine();
                line.origNo = line1.getLineNo() + 1;
                line.revisedNo = line2.getLineNo() + 1;
                line.symbol = "";
                line.text = line1.getText();
                line.trClass = "";
                if (i == 0) {
                    line.isFirst = true;
                }
                if (i + 1 == orig.getLength()) {
                    line.isLast = true;
                }
                rows.add(line);
            }
        } else {
            SingleLine line;
            if (orig != null) {
                for (i = 0; i < orig.getLength(); ++i) {
                    DiffLine line2 = orig.getLines().get(i);
                    line = new SingleLine();
                    line.origNo = line2.getLineNo() + 1;
                    line.revisedNo = -1;
                    line.symbol = "-";
                    line.text = line2.getLineNo() < originalLines.length ? this.simpleProcessSourceLine(originalLines[line2.getLineNo()]) : "";
                    String string = line.trClass = block.getType() == DiffBlock.BlockType.MODIFY ? "mdelete" : "delete";
                    if (i == 0) {
                        line.isFirst = true;
                    }
                    if (block.getType() == DiffBlock.BlockType.DELETE && i + 1 == orig.getLength()) {
                        line.isLast = true;
                    }
                    rows.add(line);
                }
            }
            if (revised != null) {
                for (i = 0; i < revised.getLength(); ++i) {
                    line1 = revised.getLines().get(i);
                    line = new SingleLine();
                    line.origNo = -1;
                    line.revisedNo = line1.getLineNo() + 1;
                    line.symbol = "+";
                    line.text = line1.getLineNo() < revisedLines.length ? this.simpleProcessSourceLine(revisedLines[line1.getLineNo()]) : "";
                    String string = line.trClass = block.getType() == DiffBlock.BlockType.MODIFY ? "minsert" : "insert";
                    if (block.getType() == DiffBlock.BlockType.INSERT && i == 0) {
                        line.isFirst = true;
                    }
                    if (i + 1 == revised.getLength()) {
                        line.isLast = true;
                    }
                    rows.add(line);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (SingleLine each : rows) {
            sb.append(this.renderSingleLine(block, each, blockNum)).append("\n");
        }
        return sb.toString();
    }

    String renderSingleLine(DiffBlock diffBlock, SingleLine line, int blockNum) {
        StringBuffer sb = new StringBuffer();
        String css = diffBlock.getType() == DiffBlock.BlockType.EQUAL ? "" : "change-section ";
        sb.append("<tr class='source-line ").append(line.trClass == null ? css : css + line.trClass);
        if (line.isFirst) {
            sb.append(" first");
        }
        if (line.isLast) {
            sb.append(" last");
        }
        sb.append("'>");
        sb.append("  <td class='line-anno line-no original'>").append(line.origNo > 0 ? String.valueOf(line.origNo) : "&nbsp;");
        if (line.isFirst && diffBlock.getType() != DiffBlock.BlockType.EQUAL) {
            sb.append("<a name='block-" + blockNum + "'></a>");
        }
        sb.append("</td>").append("  <td class='line-anno line-no revised'>").append(line.revisedNo > 0 ? String.valueOf(line.revisedNo) : "&nbsp;").append("</td>").append("  <td class='line-action'><div class='action-wrapper'>").append(Strings.isNullOrEmpty((String)line.symbol) ? "&nbsp;" : line.symbol).append("</div></td>").append("  <td class='line-content'><div class='content-wrapper'>").append(line.text).append("</div></td>").append("</tr>").toString();
        return sb.toString();
    }

    String[] renderAsHtml(String text, Renderer renderer) {
        String highlighted = DefaultSourceDiffPanel.renderSource(renderer, text);
        highlighted = highlighted.substring(highlighted.indexOf("\n") + 1);
        String[] lines = StringUtils.splitByWholeSeparator((String)highlighted, (String)"<br />\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].trim().length() != 0) continue;
            lines[i] = "&nbsp;";
        }
        return lines;
    }

    public static String renderSource(Renderer renderer, String source) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes("UTF-8"));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            renderer.highlight("", (InputStream)in, (OutputStream)out, "UTF-8", true);
            out.flush();
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getStartBlock() {
        return this.startBlock;
    }

    public void setStartBlock(int startBlock) {
        this.startBlock = startBlock;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String[] getRevised() {
        return this.revised;
    }

    public String[] getOriginal() {
        return this.original;
    }

    static class SingleLine {
        int origNo;
        int revisedNo;
        String symbol;
        String text;
        String trClass;
        boolean isFirst;
        boolean isLast;

        SingleLine() {
        }
    }
}

