/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.SortBehavior;
import com.pmease.quickbuild.web.behavior.SortPosition;
import com.pmease.quickbuild.web.component.configuration.ConfigurationSubordinateChooser;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.viewer.PolymorphicPropertyViewer;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.VariableEdit;
import com.pmease.quickbuild.web.page.setting.VariableOverridesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class VariablesPanel
extends Panel {
    public static final String SETTING_NAME = "variables";
    private SelectionColumn<Variable> selectionColumn;

    public VariablesPanel(final String id) {
        super(id);
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isEditSettingAllowed());
            }
        };
        this.add(new Component[]{operations});
        operations.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                VariablesPanel.this.replaceWith((Component)((Object)new VariableEdit(id, new Variable(), null)));
            }
        }});
        operations.add(new Component[]{new WebMarkupContainer("copyFrom").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationSubordinateChooser(componentId){

                    @Override
                    protected List<String> getSubordinateNames(Configuration configuration) {
                        ArrayList<String> subordinateNames = new ArrayList<String>();
                        subordinateNames.addAll(configuration.getVariableNames());
                        Collections.sort(subordinateNames);
                        return subordinateNames;
                    }

                    @Override
                    protected void subordinateSelected(Configuration configuration, String subordinateName) {
                        Variable var = configuration.findVar(subordinateName);
                        Validate.notNull((Object)var);
                        VariablesPanel.this.replaceWith((Component)((Object)new VariableEdit(id, var, null)));
                    }
                };
            }
        }})});
        operations.add(new Component[]{new Link<Void>("deleteSelected"){

            public void onClick() {
                Variable var;
                Variable each;
                Configuration configuration = Context.getConfiguration();
                Iterator i$ = VariablesPanel.this.selectionColumn.getSelections().iterator();
                while (i$.hasNext()) {
                    var = each = (Variable)i$.next();
                    boolean found = false;
                    Iterator<Variable> it = configuration.getVariables().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getName().equals(var.getName())) continue;
                        it.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getSession().warn((Serializable)((Object)("Can not delete inherited variable: " + var.getName())));
                }
                ConfigurationManager.instance.saveVariables(configuration);
                i$ = VariablesPanel.this.selectionColumn.getSelections().iterator();
                while (i$.hasNext()) {
                    var = each = (Variable)i$.next();
                    AuditManager.instance.audit(configuration, "Variable '" + var.getName() + "' was deleted.");
                }
                VariablesPanel.this.selectionColumn.getSelections().clear();
            }
        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected variables?")})});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isEditSettingAllowed()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Variable>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Variable>> cellItem, String componentId, IModel<Variable> rowModel) {
                Fragment fragment = new Fragment(componentId, "nameFrag", (MarkupContainer)VariablesPanel.this);
                cellItem.add(new Component[]{fragment});
                cellItem.add(new Behavior[]{AttributeModifier.replace((String)"nowrap", (Serializable)((Object)"true"))});
                final Variable var = (Variable)rowModel.getObject();
                Configuration configuration = Context.getConfiguration();
                Configuration declarer = configuration.findVarDeclarer(var.getName());
                Validate.notNull((Object)declarer);
                Configuration override = configuration.getParent();
                if (override != null) {
                    override = override.findVarDeclarer(var.getName());
                }
                final boolean inherited = !declarer.getId().equals(configuration.getId());
                fragment.add(new Component[]{new Label("name", var.getName())});
                Component[] componentArray = new Component[1];
                Link<Void> link = new Link<Void>("edit"){

                    public void onClick() {
                        VariablesPanel.this.replaceWith((Component)((Object)new VariableEdit(id, var, var.getName())));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                };
                componentArray[0] = link;
                fragment.add(componentArray);
                link.add(new Component[]{new WebMarkupContainer("icon"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                        tag.put("title", (CharSequence)(inherited ? "Overwrite this variable" : "Edit this variable"));
                    }
                }});
                WebMarkupContainer dragHandle = new WebMarkupContainer("dragHandle");
                dragHandle.setVisible(!inherited && SecurityHelper.isEditSettingAllowed());
                fragment.add(new Component[]{dragHandle});
                fragment.add(new Component[]{new InheritIndicator("inherit", declarer, override, VariablesPanel.SETTING_NAME)});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        VariablesPanel.this.replaceWith((Component)((Object)new VariableEdit(id, var, null)));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("find"){

                    public void onClick() {
                        VariablesPanel.this.replaceWith((Component)((Object)new VariableOverridesPanel(id, var.getName())));
                    }
                }.setVisible(!inherited)});
            }
        });
        columns.add(new AbstractColumn<Variable>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Variable>> cellItem, String componentId, IModel<Variable> rowModel) {
                Variable var = (Variable)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, var.getDescription())});
            }
        });
        columns.add(new AbstractColumn<Variable>((IModel)new Model((Serializable)((Object)"Value"))){

            public void populateItem(Item<ICellPopulator<Variable>> cellItem, String componentId, IModel<Variable> rowModel) {
                Variable var = (Variable)rowModel.getObject();
                cellItem.add(new Component[]{new PolymorphicPropertyViewer(componentId, Variable.class, new ViewContext(var).getProperty("valueProvider"))});
            }
        });
        columns.add(new AbstractColumn<Variable>((IModel)new Model((Serializable)((Object)"Prompt Setting"))){

            public void populateItem(Item<ICellPopulator<Variable>> cellItem, String componentId, IModel<Variable> rowModel) {
                Variable var = (Variable)rowModel.getObject();
                ViewContext context = new ViewContext(var);
                cellItem.add(new Component[]{new PropertyViewer(componentId, context.getBeanClass(), context.getProperty("promptSetting"))});
            }
        });
        DefaultDataTable<Variable> dataTable = new DefaultDataTable<Variable>("vars", columns, (ISortableDataProvider)new DataProvider<Variable>(){

            public Iterator<? extends Variable> iterator(int first, int count) {
                return Context.getConfiguration().findVariables().iterator();
            }

            public int size() {
                return Context.getConfiguration().findVariableNames().size();
            }
        }, Integer.MAX_VALUE){

            protected Item<Variable> newRowItem(String id, int index, IModel<Variable> model) {
                boolean inherited;
                Item item = super.newRowItem(id, index, model);
                Variable var = (Variable)item.getModelObject();
                Configuration configuration = Context.getConfiguration();
                Configuration declarer = configuration.findVarDeclarer(var.getName());
                Validate.notNull((Object)declarer);
                boolean bl = inherited = !declarer.getId().equals(configuration.getId());
                if (!inherited) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"sortable")), " ")});
                }
                return item;
            }
        };
        this.add(new Component[]{dataTable});
        if (SecurityHelper.isEditSettingAllowed()) {
            dataTable.add(new Behavior[]{new SortBehavior(){

                @Override
                public void onSort(AjaxRequestTarget target, SortPosition from, SortPosition to) {
                    Variable var = Context.getConfiguration().getVariables().remove(from.getItemIndex());
                    Context.getConfiguration().getVariables().add(to.getItemIndex(), var);
                    ConfigurationManager.instance.saveVariables(Context.getConfiguration());
                }
            }.sortable(">tbody").handle(".ui-draggable").items("tr.sortable")});
        }
    }
}

