/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class VariableEdit
extends Panel {
    public VariableEdit(String id, final Variable var, final String varName) {
        super(id);
        final EditContext editContext = new EditContext(var);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                String error = null;
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(var);
                    Configuration configuration = Context.getConfiguration();
                    if (varName == null) {
                        if (configuration.getVariableNames().contains(var.getName())) {
                            editContext.getProperty("name").setError("This name is already used by another variable in this configuration.");
                            error = "Fix errors below.";
                        } else {
                            configuration.getVariables().add(var);
                            ConfigurationManager.instance.saveVariables(configuration);
                            AuditManager.instance.audit(configuration, "Variable '" + var.getName() + "' was added.");
                            this.getSession().info((Serializable)((Object)"New variable added."));
                        }
                    } else {
                        Variable existing = VariableEdit.this.getVar(varName);
                        if (existing != null) {
                            if (!var.getName().equals(varName) && VariableEdit.this.getVar(var.getName()) != null) {
                                editContext.getProperty("name").setError("This name is already used by another variable in this configuration hierarchy.");
                                error = "Fix errors below.";
                            } else {
                                String previousAuditContent = VersionedDocument.fromBean(existing).toXML();
                                existing.setName(var.getName());
                                existing.setDescription(var.getDescription());
                                existing.setValueProvider(var.getValueProvider());
                                existing.setPromptSetting(var.getPromptSetting());
                                ConfigurationManager.instance.saveVariables(configuration);
                                AuditManager.instance.audit(configuration, "Variable '" + var.getName() + "' was modified.", VersionedDocument.fromBean(existing).toXML(), previousAuditContent);
                                this.getSession().info((Serializable)((Object)"Variable saved."));
                            }
                        } else {
                            configuration.getVariables().add(var);
                            ConfigurationManager.instance.saveVariables(configuration);
                            AuditManager.instance.audit(configuration, "Variable '" + var.getName() + "' was added.");
                            this.getSession().info((Serializable)((Object)"Variable saved."));
                        }
                    }
                } else {
                    error = "Fix errors below.";
                }
                if (error == null) {
                    PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "variables");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                } else {
                    this.getSession().error((Serializable)((Object)error));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "variables");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }

    private Variable getVar(String varName) {
        for (Variable each : Context.getConfiguration().getVariables()) {
            if (!each.getName().equals(varName)) continue;
            return each;
        }
        return null;
    }
}

