/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.FailSafeStep;
import com.pmease.quickbuild.stepsupport.SequentialStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.DragBehavior;
import com.pmease.quickbuild.web.behavior.DropBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationSubordinateChooser;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import com.pmease.quickbuild.web.page.setting.StepEdit;
import com.pmease.quickbuild.web.page.setting.StepOverridesPanel;
import com.pmease.quickbuild.web.page.setting.StepPlacement;
import com.pmease.quickbuild.web.page.setting.StepUsagesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class StepsPanel
extends Panel {
    public static final String SETTING_NAME = "steps";
    private Set<String> selected = new HashSet<String>();
    private WebMarkupContainer workflowContainer;
    private AjaxCheckBox allSelector;
    private boolean isEditSettingAllowed = SecurityHelper.isEditSettingAllowed();

    public StepsPanel(final String id) {
        super(id);
        if (!WebSession.get().isAvailabeStepsCollapsed()) {
            Fragment fragment = new Fragment("availableSteps", "availableStepsFrag", (MarkupContainer)this);
            fragment.add(new Component[]{new Link<Void>("collapse"){

                public void onClick() {
                    WebSession.get().setAvailabeStepsCollapsed(true);
                    this.setResponsePage(ConfigurationSettingPage.class, ConfigurationSettingPage.params4(Context.getConfiguration().getId(), StepsPanel.SETTING_NAME));
                }
            }});
            WebMarkupContainer body = new WebMarkupContainer("body");
            fragment.add(new Component[]{body});
            WebMarkupContainer operations = new WebMarkupContainer("operations");
            operations.setVisible(this.isEditSettingAllowed);
            body.add(new Component[]{operations});
            WebMarkupContainer addNewBtn = new WebMarkupContainer("addNew");
            operations.add(new Component[]{addNewBtn});
            addNewBtn.add(new Behavior[]{new TypeMenuBehavior<Step>(){

                @Override
                protected void onSelect(Class<Step> stepClass) {
                    try {
                        StepEdit stepEdit = new StepEdit(id, stepClass.newInstance(), null, null);
                        StepsPanel.this.replaceWith((Component)((Object)stepEdit));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
            }});
            WebMarkupContainer copyFromBtn = new WebMarkupContainer("copyFrom");
            operations.add(new Component[]{copyFromBtn});
            copyFromBtn.add(new Behavior[]{new PopupBehavior(){

                @Override
                protected Component getPopup(String componentId) {
                    return new ConfigurationSubordinateChooser(componentId){

                        @Override
                        protected List<String> getSubordinateNames(Configuration configuration) {
                            ArrayList<String> objectNames = new ArrayList<String>();
                            objectNames.addAll(configuration.getStepNames());
                            Collections.sort(objectNames);
                            return objectNames;
                        }

                        @Override
                        protected void subordinateSelected(Configuration configuration, String objectName) {
                            Step step = configuration.findStep(objectName);
                            Validate.notNull((Object)step);
                            StepsPanel.this.replaceWith((Component)((Object)new StepEdit(id, step, null, null)));
                        }
                    };
                }
            }});
            Component[] componentArray = new Component[1];
            Link<Void> link = new Link<Void>("deleteSelected"){

                public void onClick() {
                    Configuration configuration = Context.getConfiguration();
                    Set<String> stepNames = configuration.getStepNames();
                    for (String stepName : StepsPanel.this.selected) {
                        if (stepName.equals("master") && configuration.isRoot()) {
                            this.getSession().warn((Serializable)((Object)"Can not delete master step in root configuration."));
                            continue;
                        }
                        if (!stepNames.contains(stepName)) {
                            this.getSession().warn((Serializable)((Object)("Can not delete inherited step: " + stepName)));
                            continue;
                        }
                        ConfigurationManager.instance.deleteStep(configuration, stepName);
                        AuditManager.instance.audit(configuration, "Step '" + stepName + "' was deleted.");
                    }
                    StepsPanel.this.selected.clear();
                }
            };
            componentArray[0] = link;
            operations.add(componentArray);
            link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected steps?")});
            Component[] componentArray2 = new Component[1];
            this.allSelector = new AjaxCheckBox("allSelector", (IModel)new IModel<Boolean>(){

                public Boolean getObject() {
                    Map<String, Step> steps = Context.getConfiguration().findSteps();
                    if (steps.isEmpty()) {
                        return false;
                    }
                    return StepsPanel.this.selected.containsAll(steps.keySet());
                }

                public void setObject(Boolean object) {
                    StepsPanel.this.selected.clear();
                    if (object.booleanValue()) {
                        StepsPanel.this.selected.addAll(Context.getConfiguration().findSteps().keySet());
                    }
                }

                public void detach() {
                }
            }){

                protected boolean wantOnSelectionChangedNotifications() {
                    return true;
                }

                protected void onUpdate(AjaxRequestTarget target) {
                }
            };
            componentArray2[0] = this.allSelector;
            operations.add(componentArray2);
            this.allSelector.setOutputMarkupId(true);
            this.allSelector.add(new Behavior[]{new Behavior(){

                public void onComponentTag(Component component, ComponentTag tag) {
                    super.onComponentTag(component, tag);
                    String existingOnClickScript = tag.getAttribute("onclick");
                    tag.put("onclick", (CharSequence)("var checked=this.checked;$(this).closest('table').find('.row-selector').each(function() {this.checked = checked;});" + existingOnClickScript));
                }
            }});
            body.add(new Component[]{new ListView<Step>(SETTING_NAME, (IModel)new LoadableDetachableModel<List<Step>>(){

                protected List<Step> load() {
                    Configuration configuration = Context.getConfiguration();
                    Map<String, Step> map = configuration.findSteps();
                    ArrayList<Step> list = new ArrayList<Step>(map.values());
                    Collections.sort(list, new Comparator<Step>(){

                        @Override
                        public int compare(Step step1, Step step2) {
                            if (step1.isMaster()) {
                                return -1;
                            }
                            if (step2.isMaster()) {
                                return 1;
                            }
                            return step1.getName().compareTo(step2.getName());
                        }
                    });
                    return list;
                }
            }){

                protected void populateItem(ListItem<Step> item) {
                    final Step step = (Step)item.getModelObject();
                    item.add(new Component[]{new AjaxCheckBox("rowSelector", (IModel)new IModel<Boolean>(){

                        public Boolean getObject() {
                            return StepsPanel.this.selected.contains(step.getName());
                        }

                        public void setObject(Boolean object) {
                            if (object.booleanValue()) {
                                StepsPanel.this.selected.add(step.getName());
                            } else {
                                StepsPanel.this.selected.remove(step.getName());
                            }
                        }

                        public void detach() {
                        }
                    }){

                        protected boolean wantOnSelectionChangedNotifications() {
                            return true;
                        }

                        protected void onUpdate(AjaxRequestTarget target) {
                            target.add(new Component[]{StepsPanel.this.allSelector});
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(StepsPanel.this.isEditSettingAllowed);
                        }
                    }});
                    Configuration current = Context.getConfiguration();
                    Configuration declarer = current.findStepDeclarer(step.getName());
                    Validate.notNull((Object)declarer);
                    Configuration override = current.getParent();
                    if (override != null) {
                        override = override.findStepDeclarer(step.getName());
                    }
                    final boolean inherited = !declarer.getId().equals(current.getId());
                    Label label = new Label("name", step.getName());
                    item.add(new Component[]{label});
                    if (!(step instanceof FailSafeStep)) {
                        label.add(new Behavior[]{new PopupBehavior(){

                            @Override
                            protected Component getPopup(String componentId) {
                                if (step.isMaster()) {
                                    return new BeanViewer(componentId, new ViewContext(step, Step.MASTER_EXCLUDED_PROPERTIES, true));
                                }
                                return new BeanViewer(componentId, new ViewContext(step));
                            }
                        }.hoverMode(true)});
                    }
                    Component[] componentArray = new Component[1];
                    Link<Void> link = new Link<Void>("edit"){

                        public void onClick() {
                            StepsPanel.this.replaceWith((Component)((Object)new StepEdit(id, step, step.getName(), null)));
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(StepsPanel.this.isEditSettingAllowed);
                        }
                    };
                    componentArray[0] = link;
                    item.add(componentArray);
                    link.add(new Component[]{new WebMarkupContainer("icon"){

                        protected void onComponentTag(ComponentTag tag) {
                            super.onComponentTag(tag);
                            tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                            tag.put("title", (CharSequence)(inherited ? "Overwrite this step" : "Edit this step"));
                        }
                    }});
                    item.add(new Component[]{new Link<Void>("copy"){

                        public void onClick() {
                            StepsPanel.this.replaceWith((Component)((Object)new StepEdit(id, step, null, null)));
                        }

                        protected void onConfigure() {
                            super.onConfigure();
                            this.setVisible(StepsPanel.this.isEditSettingAllowed);
                        }
                    }});
                    WebMarkupContainer findLink = new WebMarkupContainer("find");
                    findLink.setVisible(!inherited);
                    findLink.add(new Behavior[]{new MenuBehavior(){

                        @Override
                        protected List<MenuItem> getMenuItems() {
                            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                            menuItems.add(new MenuItem(){

                                @Override
                                public Component render(String componentId) {
                                    return new TextLink<Void>(componentId, "Find Overrides"){

                                        public void onClick() {
                                            StepsPanel.this.replaceWith((Component)((Object)new StepOverridesPanel(id, step.getName())));
                                        }
                                    };
                                }
                            });
                            menuItems.add(new MenuItem(){

                                @Override
                                public Component render(String componentId) {
                                    return new TextLink<Void>(componentId, "Find Other Steps Using this Step"){

                                        public void onClick() {
                                            StepsPanel.this.replaceWith((Component)((Object)new StepUsagesPanel(id, step.getName())));
                                        }
                                    };
                                }
                            });
                            return menuItems;
                        }
                    }});
                    item.add(new Component[]{findLink});
                    item.add(new Component[]{new InheritIndicator("inherit", declarer, override, StepsPanel.SETTING_NAME)});
                    WebMarkupContainer dragHandle = new WebMarkupContainer("dragHandle");
                    item.add(new Component[]{dragHandle});
                    if (StepsPanel.this.isEditSettingAllowed && !step.isMaster()) {
                        dragHandle.add(new Behavior[]{new DragBehavior(step.getName())});
                    } else {
                        dragHandle.setVisible(false);
                    }
                }
            }});
            if (this.isEditSettingAllowed) {
                body.add(new Behavior[]{new DropBehavior("#workflow *"){

                    @Override
                    public void onDropped(AjaxRequestTarget target, String dragData) {
                        StepsPanel.this.onStepDropped(target, dragData, null, null);
                    }
                }});
            }
            this.add(new Component[]{fragment});
        } else {
            Fragment fragment = new Fragment("availableSteps", "collapsedAvailableStepsFrag", (MarkupContainer)this);
            fragment.add(new Component[]{new Link<Void>("expand"){

                public void onClick() {
                    WebSession.get().setAvailabeStepsCollapsed(false);
                    this.setResponsePage(ConfigurationSettingPage.class, ConfigurationSettingPage.params4(Context.getConfiguration().getId(), StepsPanel.SETTING_NAME));
                }
            }});
            fragment.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)" collapsed"))});
            this.add(new Component[]{fragment});
        }
        Component[] componentArray = new Component[1];
        this.workflowContainer = new WebMarkupContainer("workflow"){

            protected void onBeforeRender() {
                this.replace((Component)((Object)new StepView("masterStep", "master")));
                super.onBeforeRender();
            }
        };
        componentArray[0] = this.workflowContainer;
        this.add(componentArray);
        this.workflowContainer.setOutputMarkupId(true);
        this.workflowContainer.add(new Component[]{new StepView("masterStep", "master")});
        this.add(new Component[]{new WebMarkupContainer("hint"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(StepsPanel.this.isEditSettingAllowed);
            }
        }});
    }

    private void onStepDropped(AjaxRequestTarget target, String dragSource, String dropTarget, DropPosition dropPosition) {
        Configuration configuration = Context.getConfiguration();
        String sourceName = this.getStepName(dragSource);
        if (dragSource.indexOf(62) != -1) {
            CompositeStep sourceParent = this.getParentStep(dragSource);
            if (dropTarget != null) {
                String targetName = this.getStepName(dropTarget);
                if (sourceName.equals(targetName)) {
                    if (dropPosition == DropPosition.INSIDE) {
                        this.getSession().error((Serializable)((Object)"Can not move a step to be inside itself."));
                    }
                    return;
                }
                if (this.isStepContained(dragSource, dropTarget)) {
                    this.getSession().error((Serializable)((Object)"Can not move step to its children."));
                    return;
                }
                if (dropPosition == DropPosition.SWAP) {
                    CompositeStep targetParent = this.getParentStep(dropTarget);
                    if (sourceParent.equals(targetParent)) {
                        String previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                        List<String> children = targetParent.getChildStepNames();
                        int sourceIndex = children.indexOf(sourceName);
                        int targetIndex = children.indexOf(targetName);
                        children.set(sourceIndex, targetName);
                        children.set(targetIndex, sourceName);
                        ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
                    } else {
                        if (sourceParent.getChildStepNames().contains(targetName)) {
                            this.getSession().error((Serializable)((Object)("Can not swap since step '" + sourceParent.getName() + "' already contains child '" + targetName + "'.")));
                            return;
                        }
                        if (targetParent.getChildStepNames().contains(sourceName)) {
                            this.getSession().error((Serializable)((Object)("Can not swap since step '" + targetParent.getName() + "' already contains child '" + sourceName + "'.")));
                            return;
                        }
                        int sourceIndex = sourceParent.getChildStepNames().indexOf(sourceName);
                        String previousAuditContent = VersionedDocument.fromBean(sourceParent).toXML();
                        sourceParent.getChildStepNames().set(sourceIndex, targetName);
                        ConfigurationManager.instance.saveStep(configuration, sourceParent, sourceParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + sourceParent.getName() + "' was modified.", VersionedDocument.fromBean(sourceParent).toXML(), previousAuditContent);
                        int targetIndex = targetParent.getChildStepNames().indexOf(targetName);
                        previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                        targetParent.getChildStepNames().set(targetIndex, sourceName);
                        ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
                    }
                } else if (dropPosition == DropPosition.INSIDE) {
                    if (!sourceParent.getName().equals(targetName)) {
                        CompositeStep targetStep = (CompositeStep)configuration.findStep(targetName);
                        if (targetStep.getChildStepNames().contains(sourceName)) {
                            this.getSession().error((Serializable)((Object)("Can not move since step '" + targetStep.getName() + "' already contains child '" + sourceName + "'.")));
                            return;
                        }
                        String previousAuditContent = VersionedDocument.fromBean(sourceParent).toXML();
                        sourceParent.getChildStepNames().remove(sourceName);
                        ConfigurationManager.instance.saveStep(configuration, sourceParent, sourceParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + sourceParent.getName() + "' was modified.", VersionedDocument.fromBean(sourceParent).toXML(), previousAuditContent);
                        previousAuditContent = VersionedDocument.fromBean(targetStep).toXML();
                        targetStep.getChildStepNames().add(sourceName);
                        ConfigurationManager.instance.saveStep(configuration, targetStep, targetName);
                        AuditManager.instance.audit(configuration, "Step '" + targetName + "' was modified.", VersionedDocument.fromBean(targetStep).toXML(), previousAuditContent);
                    }
                } else {
                    CompositeStep targetParent = this.getParentStep(dropTarget);
                    if (targetParent.equals(sourceParent)) {
                        String previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                        List<String> children = targetParent.getChildStepNames();
                        children.remove(sourceName);
                        int targetIndex = children.indexOf(targetName);
                        if (dropPosition == DropPosition.AFTER) {
                            ++targetIndex;
                        }
                        children.add(targetIndex, sourceName);
                        ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
                    } else {
                        List<String> targetChildren = targetParent.getChildStepNames();
                        if (targetChildren.contains(sourceName)) {
                            this.getSession().error((Serializable)((Object)("Can not move since step '" + targetParent.getName() + "' already contains child '" + sourceName + "'.")));
                            return;
                        }
                        String previousAuditContent = VersionedDocument.fromBean(sourceParent).toXML();
                        sourceParent.getChildStepNames().remove(sourceName);
                        ConfigurationManager.instance.saveStep(configuration, sourceParent, sourceParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + sourceParent.getName() + " was modified.", VersionedDocument.fromBean(sourceParent).toXML(), previousAuditContent);
                        previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                        int targetIndex = targetChildren.indexOf(targetName);
                        if (dropPosition == DropPosition.AFTER) {
                            ++targetIndex;
                        }
                        targetChildren.add(targetIndex, sourceName);
                        ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                        AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
                    }
                }
            } else {
                String previousAuditContent = VersionedDocument.fromBean(sourceParent).toXML();
                sourceParent.getChildStepNames().remove(sourceName);
                ConfigurationManager.instance.saveStep(configuration, sourceParent, sourceParent.getName());
                AuditManager.instance.audit(configuration, "Step '" + sourceParent.getName() + "' was modified.", VersionedDocument.fromBean(sourceParent).toXML(), previousAuditContent);
            }
        } else {
            String targetName = this.getStepName(dropTarget);
            if (sourceName.equals(targetName)) {
                if (dropPosition == DropPosition.INSIDE) {
                    this.getSession().error((Serializable)((Object)"Can not move a step to be inside itself."));
                } else if (dropPosition != DropPosition.SWAP) {
                    CompositeStep targetParent = this.getParentStep(dropTarget);
                    this.getSession().error((Serializable)((Object)("Can not move since step '" + targetParent.getName() + "' already contains child '" + sourceName + "'.")));
                }
                return;
            }
            if (dropPosition == DropPosition.SWAP) {
                CompositeStep targetParent = this.getParentStep(dropTarget);
                if (targetParent.getChildStepNames().contains(sourceName)) {
                    this.getSession().error((Serializable)((Object)("Can not swap since step '" + targetParent.getName() + "' already contains child '" + sourceName + "'.")));
                    return;
                }
                String previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                List<String> children = targetParent.getChildStepNames();
                children.set(children.indexOf(targetName), sourceName);
                ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
            } else if (dropPosition == DropPosition.INSIDE) {
                CompositeStep targetStep = (CompositeStep)configuration.findStep(targetName);
                if (targetStep.getChildStepNames().contains(sourceName)) {
                    this.getSession().error((Serializable)((Object)("Can not move since step '" + targetName + " already contains child '" + sourceName + "'.")));
                    return;
                }
                String previousAuditContent = VersionedDocument.fromBean(targetStep).toXML();
                targetStep.getChildStepNames().add(sourceName);
                ConfigurationManager.instance.saveStep(configuration, targetStep, targetName);
                AuditManager.instance.audit(configuration, "Step '" + targetName + "' was modified.", VersionedDocument.fromBean(targetStep).toXML(), previousAuditContent);
            } else {
                CompositeStep targetParent = this.getParentStep(dropTarget);
                List<String> children = targetParent.getChildStepNames();
                if (children.contains(sourceName)) {
                    this.getSession().error((Serializable)((Object)("Can not move since step '" + targetParent.getName() + "' already contains child '" + sourceName + "'.")));
                    return;
                }
                String previousAuditContent = VersionedDocument.fromBean(targetParent).toXML();
                int targetIndex = children.indexOf(targetName);
                if (dropPosition == DropPosition.AFTER) {
                    ++targetIndex;
                }
                children.add(targetIndex, sourceName);
                ConfigurationManager.instance.saveStep(configuration, targetParent, targetParent.getName());
                AuditManager.instance.audit(configuration, "Step '" + targetParent.getName() + "' was modified.", VersionedDocument.fromBean(targetParent).toXML(), previousAuditContent);
            }
        }
        target.add(new Component[]{this.workflowContainer});
    }

    private CompositeStep getParentStep(String pathName) {
        List<String> path = StringUtils.splitAndTrim(pathName, '>');
        Validate.isTrue((path.size() > 1 ? 1 : 0) != 0);
        String parentName = path.get(path.size() - 2);
        Step parentStep = Context.getConfiguration().findStep(parentName);
        Validate.notNull((Object)parentStep);
        return (CompositeStep)parentStep;
    }

    private String getStepName(String pathName) {
        if (pathName.indexOf(62) != -1) {
            return StringUtils.substringAfterLast((String)pathName, (String)String.valueOf('>'));
        }
        return pathName;
    }

    private boolean isStepContained(String parentStepPath, String childStepPath) {
        if (childStepPath.startsWith(parentStepPath)) {
            return childStepPath.charAt(parentStepPath.length()) == '>';
        }
        return false;
    }

    private class StepView
    extends Fragment {
        private String stepName;
        private List<String> parentStepPath;
        private IModel<Step> parentStepModel;

        public StepView(String id, final String stepName, final List<String> parentStepPath) {
            Fragment body;
            super(id, "stepViewFrag", (MarkupContainer)StepsPanel.this, (IModel)new LoadableDetachableModel<Step>(){

                protected Step load() {
                    Step step;
                    if (parentStepPath.contains(stepName)) {
                        step = new FailSafeStep();
                        step.setDescription("Step circular reference found");
                        step.setName(stepName);
                    } else {
                        step = Context.getConfiguration().findStep(stepName);
                    }
                    return step;
                }
            });
            this.parentStepPath = parentStepPath;
            this.stepName = stepName;
            this.parentStepModel = new LoadableDetachableModel<Step>(){

                protected Step load() {
                    if (parentStepPath.isEmpty()) {
                        return null;
                    }
                    String parentName = (String)parentStepPath.get(parentStepPath.size() - 1);
                    return Context.getConfiguration().findStep(parentName);
                }
            };
            WebMarkupContainer head = new WebMarkupContainer("head");
            Label stepLabel = new Label("name", stepName);
            stepLabel.add(new Behavior[]{new PopupBehavior(){

                @Override
                protected Component getPopup(String componentId) {
                    if (StepView.this.getStep() == null) {
                        return new Label(componentId, "This step is not defined.");
                    }
                    if (StepView.this.getStep() instanceof FailSafeStep) {
                        return new Label(componentId, StepView.this.getStep().getDescription());
                    }
                    if (StepView.this.getStep().isMaster()) {
                        return new BeanViewer(componentId, new ViewContext(StepView.this.getStep(), Step.MASTER_EXCLUDED_PROPERTIES, true));
                    }
                    return new BeanViewer(componentId, new ViewContext(StepView.this.getStep()));
                }
            }.hoverMode(true)});
            head.add(new Component[]{stepLabel});
            Configuration current = Context.getConfiguration();
            Configuration declarer = current.findStepDeclarer(stepName);
            final boolean inherited = declarer != null && !current.getId().equals(declarer.getId());
            Link<Void> editLink = new Link<Void>("edit"){

                public void onClick() {
                    StepsPanel.this.replaceWith((Component)((Object)new StepEdit(StepsPanel.this.getId(), StepView.this.getStep(), stepName, null)));
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (Context.getConfiguration().getStepDOMs().containsKey(stepName)) {
                        tag.put("src", (CharSequence)"/images/edit.png");
                    } else {
                        tag.put("src", (CharSequence)"/images/overwrite.png");
                    }
                    if (inherited) {
                        tag.put("title", (CharSequence)"Override this step");
                    } else {
                        tag.put("title", (CharSequence)"Edit this step");
                    }
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep() != null && !(StepView.this.getStep() instanceof FailSafeStep) && StepsPanel.this.isEditSettingAllowed);
                }
            };
            head.add(new Component[]{editLink});
            AjaxLink<Void> toggleLink = new AjaxLink<Void>("toggle"){

                public void onClick(AjaxRequestTarget target) {
                    Configuration configuration = Context.getConfiguration();
                    Step step = StepView.this.getStep();
                    String previousAuditContent = VersionedDocument.fromBean(step).toXML();
                    step.setEnabled(!step.isEnabled());
                    VersionedDocument dom = VersionedDocument.fromBean(step);
                    configuration.getStepDOMs().put(step.getName(), dom);
                    ConfigurationManager.instance.save(configuration);
                    AuditManager.instance.audit(configuration, "Step '" + step.getName() + "' was modified.", dom.toXML(), previousAuditContent);
                    target.add(new Component[]{StepView.this});
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (StepView.this.getStep().isEnabled()) {
                        tag.put("src", (CharSequence)"/images/enable.gif");
                        if (!inherited) {
                            tag.put("title", (CharSequence)"Step is enabled. Click to disable.");
                        } else {
                            tag.put("title", (CharSequence)"Step is enabled. Click to override as disabled.");
                        }
                    } else {
                        tag.put("src", (CharSequence)"/images/disable.png");
                        if (!inherited) {
                            tag.put("title", (CharSequence)"Step is disabled. Click to enable.");
                        } else {
                            tag.put("title", (CharSequence)"Step is disabled. Click to override as enabled.");
                        }
                    }
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep() != null && !(StepView.this.getStep() instanceof FailSafeStep) && !StepView.this.getStep().isMaster() && StepsPanel.this.isEditSettingAllowed);
                }
            };
            head.add(new Component[]{toggleLink});
            Link<Void> deleteLink = new Link<Void>("delete"){

                public void onClick() {
                    Configuration configuration = Context.getConfiguration();
                    AuditManager.instance.audit(configuration, "Step '" + stepName + "' was deleted.");
                    ConfigurationManager.instance.deleteStep(configuration, stepName);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("src", (CharSequence)"/images/delete.png");
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep() != null && !inherited && StepsPanel.this.isEditSettingAllowed && (!StepView.this.getStep().isMaster() || !Context.getConfiguration().isRoot() || StepView.this.getStep() instanceof FailSafeStep));
                }
            };
            deleteLink.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete this step?")});
            head.add(new Component[]{deleteLink});
            InternalImage addButton = new InternalImage("add", "/images/add.png"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep() == null && StepsPanel.this.isEditSettingAllowed);
                }
            };
            addButton.setOutputMarkupId(true);
            head.add(new Component[]{addButton});
            addButton.add(new Behavior[]{new TypeMenuBehavior<Step>(){

                @Override
                public void onSelect(Class<Step> stepClass) {
                    try {
                        Step step = stepClass.newInstance();
                        step.setName(stepName);
                        StepEdit stepEdit = new StepEdit(StepsPanel.this.getId(), step, null, null);
                        StepsPanel.this.replaceWith((Component)((Object)stepEdit));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
            }});
            InternalImage addInsideButton = new InternalImage("addInside", "/images/add.png"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep() instanceof CompositeStep && StepsPanel.this.isEditSettingAllowed);
                }
            };
            addInsideButton.setOutputMarkupId(true);
            head.add(new Component[]{addInsideButton});
            addInsideButton.add(new Behavior[]{new TypeMenuBehavior<Step>(){

                @Override
                public void onSelect(Class<Step> stepClass) {
                    try {
                        ArrayList<String> stepPath = new ArrayList<String>(parentStepPath);
                        stepPath.add(stepName);
                        StepEdit stepEdit = new StepEdit(StepsPanel.this.getId(), stepClass.newInstance(), null, new StepPlacement(stepPath, StepPlacement.Position.INSIDE));
                        StepsPanel.this.replaceWith((Component)((Object)stepEdit));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
            }});
            InternalImage addBeforeButton = new InternalImage("addBefore", this.getParentStep() instanceof SequentialStep ? "/images/add-top.png" : "/images/add-left.png"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getParentStep() != null && StepsPanel.this.isEditSettingAllowed);
                }
            };
            addBeforeButton.setOutputMarkupId(true);
            head.add(new Component[]{addBeforeButton});
            addBeforeButton.add(new Behavior[]{new TypeMenuBehavior<Step>(){

                @Override
                public void onSelect(Class<Step> stepClass) {
                    try {
                        ArrayList<String> stepPath = new ArrayList<String>(parentStepPath);
                        stepPath.add(stepName);
                        StepEdit stepEdit = new StepEdit(StepsPanel.this.getId(), stepClass.newInstance(), null, new StepPlacement(stepPath, StepPlacement.Position.BEFORE));
                        StepsPanel.this.replaceWith((Component)((Object)stepEdit));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
            }});
            InternalImage addAfterButton = new InternalImage("addAfter", this.getParentStep() instanceof SequentialStep ? "/images/add-bottom.png" : "/images/add-right.png"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getParentStep() != null && StepsPanel.this.isEditSettingAllowed);
                }
            };
            addAfterButton.setOutputMarkupId(true);
            head.add(new Component[]{addAfterButton});
            addAfterButton.add(new Behavior[]{new TypeMenuBehavior<Step>(){

                @Override
                public void onSelect(Class<Step> stepClass) {
                    try {
                        ArrayList<String> stepPath = new ArrayList<String>(parentStepPath);
                        stepPath.add(stepName);
                        StepEdit stepEdit = new StepEdit(StepsPanel.this.getId(), stepClass.newInstance(), null, new StepPlacement(stepPath, StepPlacement.Position.AFTER));
                        StepsPanel.this.replaceWith((Component)((Object)stepEdit));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
            }});
            if (declarer != null) {
                Configuration override = Context.getConfiguration().getParent();
                if (override != null) {
                    override = override.findStepDeclarer(stepName);
                }
                head.add(new Component[]{new InheritIndicator("inherit", declarer, override, StepsPanel.SETTING_NAME)});
            } else {
                head.add(new Component[]{new WebMarkupContainer("inherit")});
            }
            WebMarkupContainer dragHandle = new WebMarkupContainer("dragHandle");
            dragHandle.setVisible(StepsPanel.this.isEditSettingAllowed && !stepName.equals("master"));
            head.add(new Component[]{dragHandle});
            this.add(new Component[]{head});
            if (!stepName.equals("master") && StepsPanel.this.isEditSettingAllowed) {
                dragHandle.add(new Behavior[]{new DragBehavior(this.getStepPathName())});
                head.add(new Behavior[]{new DropBehavior("*"){

                    @Override
                    public void onDropped(AjaxRequestTarget target, String dragData) {
                        StepsPanel.this.onStepDropped(target, dragData, StepView.this.getStepPathName(), DropPosition.SWAP);
                    }
                }});
            }
            if (this.getStep() == null) {
                body = new Fragment("body", "errorFrag", (MarkupContainer)StepsPanel.this);
                if (stepName.equals("master")) {
                    body.add(new Component[]{new Label("error", "Master step needs to be defined and will be used as execution entry when build runs. Click the add icon to get it defined.")});
                } else {
                    body.add(new Component[]{new Label("error", "Step not found.")});
                }
            } else if (this.getStep() instanceof FailSafeStep) {
                body = new Fragment("body", "errorFrag", (MarkupContainer)StepsPanel.this);
                body.add(new Component[]{new Label("error", this.getStep().getDescription())});
            } else if (this.getStep() instanceof CompositeStep) {
                CompositeStep compositeStep = (CompositeStep)this.getStep();
                if (!compositeStep.getChildStepNames().isEmpty()) {
                    if (compositeStep instanceof SequentialStep) {
                        body = new Fragment("body", "sequentialFrag", (MarkupContainer)StepsPanel.this);
                        body.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"body sequential"))});
                        this.renderCompositeBody((WebMarkupContainer)body, compositeStep);
                    } else {
                        body = new Fragment("body", "parallelFrag", (MarkupContainer)StepsPanel.this);
                        body.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"body parallel"))});
                        this.renderCompositeBody((WebMarkupContainer)body, compositeStep);
                    }
                } else {
                    body = new Fragment("body", "emptyFrag", (MarkupContainer)StepsPanel.this);
                    if (StepsPanel.this.isEditSettingAllowed) {
                        body.add(new Behavior[]{new DropBehavior("*"){

                            @Override
                            public void onDropped(AjaxRequestTarget target, String dragData) {
                                StepsPanel.this.onStepDropped(target, dragData, StepView.this.getStepPathName(), DropPosition.INSIDE);
                            }
                        }});
                    }
                }
            } else {
                body = new WebMarkupContainer("body");
                body.setVisible(false);
            }
            this.add(new Component[]{body});
            this.setOutputMarkupId(true);
        }

        protected void onDetach() {
            super.onDetach();
            if (this.parentStepModel != null) {
                this.parentStepModel.detach();
            }
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String cssClass = tag.getAttribute("class");
            cssClass = cssClass != null ? cssClass + " step" : "step";
            Step step = this.getStep();
            cssClass = this.parentStepPath.size() % 2 == 0 ? cssClass + " even" : cssClass + " odd";
            Configuration current = Context.getConfiguration();
            Configuration declarer = current.findStepDeclarer(this.stepName);
            if (declarer != null && !current.getId().equals(declarer.getId())) {
                cssClass = cssClass + " inherited";
            }
            if (step == null || step instanceof FailSafeStep) {
                cssClass = cssClass + " error";
            }
            tag.put("class", (CharSequence)cssClass);
        }

        public StepView(String id, String stepName) {
            this(id, stepName, new ArrayList<String>());
        }

        private Step getStep() {
            return (Step)this.getDefaultModelObject();
        }

        private Step getParentStep() {
            return (Step)this.parentStepModel.getObject();
        }

        private String getStepPathName() {
            if (!this.parentStepPath.isEmpty()) {
                return StringUtils.join(this.parentStepPath, (char)'>') + '>' + this.stepName;
            }
            return this.stepName;
        }

        private void renderCompositeBody(WebMarkupContainer body, CompositeStep step) {
            body.add(new Component[]{new ListView<String>("children", new ArrayList<String>(step.getChildStepNames())){

                protected void populateItem(ListItem<String> item) {
                    ArrayList<String> childParentStepPath = new ArrayList<String>(StepView.this.parentStepPath);
                    childParentStepPath.add(StepView.this.stepName);
                    final String childStepPathName = StringUtils.join(childParentStepPath, (char)'>') + '>' + (String)item.getModelObject();
                    WebMarkupContainer before = new WebMarkupContainer("before");
                    before.setVisible(item.getIndex() == 0);
                    item.add(new Component[]{before});
                    item.add(new Component[]{new StepView("step", (String)item.getModelObject(), childParentStepPath)});
                    WebMarkupContainer after = new WebMarkupContainer("after");
                    item.add(new Component[]{after});
                    if (StepsPanel.this.isEditSettingAllowed) {
                        before.add(new Behavior[]{new DropBehavior("*"){

                            @Override
                            public void onDropped(AjaxRequestTarget target, String dragData) {
                                StepsPanel.this.onStepDropped(target, dragData, childStepPathName, DropPosition.BEFORE);
                            }
                        }});
                        after.add(new Behavior[]{new DropBehavior("*"){

                            @Override
                            public void onDropped(AjaxRequestTarget target, String dragData) {
                                StepsPanel.this.onStepDropped(target, dragData, childStepPathName, DropPosition.AFTER);
                            }
                        }});
                    }
                }
            }});
        }
    }

    private static enum DropPosition {
        BEFORE,
        AFTER,
        INSIDE,
        SWAP;

    }
}

