/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class StepUsagesPanel
extends Panel {
    private final String stepName;
    private IModel<List<StepUsage>> usagesModel = new LoadableDetachableModel<List<StepUsage>>(){

        protected List<StepUsage> load() {
            return this.findUsages(Context.getConfiguration());
        }

        List<StepUsage> findUsages(Configuration configuration) {
            ArrayList<StepUsage> usages = new ArrayList<StepUsage>();
            StepUsage usage = new StepUsage();
            usage.setConfiguration(configuration);
            for (Step step : configuration.getSteps().values()) {
                CompositeStep compositeStep;
                if (!(step instanceof CompositeStep) || !(compositeStep = (CompositeStep)step).getChildStepNames().contains(StepUsagesPanel.this.stepName)) continue;
                usage.getStepNames().add(step.getName());
            }
            if (!usage.getStepNames().isEmpty()) {
                usages.add(usage);
            }
            for (Configuration child : configuration.getChildren()) {
                if (child.getStepDOMs().containsKey(StepUsagesPanel.this.stepName)) continue;
                usages.addAll(this.findUsages(child));
            }
            return usages;
        }
    };

    public StepUsagesPanel(String id, String stepName) {
        super(id);
        this.stepName = stepName;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (((List)StepUsagesPanel.this.usagesModel.getObject()).isEmpty()) {
                    return "Found no other steps using step '" + StepUsagesPanel.this.stepName + "'";
                }
                return "Other steps using step '" + StepUsagesPanel.this.stepName + "'";
            }
        })});
        this.add(new Component[]{new ListView<StepUsage>("usages", this.usagesModel){

            protected void populateItem(final ListItem<StepUsage> item) {
                BookmarkablePageLink<Void> link = new BookmarkablePageLink<Void>("link", ConfigurationSettingPage.class, ConfigurationSettingPage.params4(((StepUsage)item.getModelObject()).getConfiguration().getId(), "steps")){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setEnabled(SecurityHelper.hasPermission(((StepUsage)item.getModelObject()).getConfiguration()));
                    }
                };
                Label label = new Label("label", ((StepUsage)item.getModelObject()).getConfiguration().getPathName());
                label.setRenderBodyOnly(true);
                link.add(new Component[]{label});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("steps", StringUtils.join(((StepUsage)item.getModelObject()).getStepNames()))});
            }
        }});
    }

    protected void onDetach() {
        this.usagesModel.detach();
        super.onDetach();
    }

    private static class StepUsage {
        private Configuration configuration;
        private List<String> stepNames = new ArrayList<String>();

        private StepUsage() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public List<String> getStepNames() {
            return this.stepNames;
        }
    }
}

