/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import com.pmease.quickbuild.web.page.setting.StepPlacement;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class StepEdit
extends Panel {
    private String stepName;

    public StepEdit(final String id, final Step step, final String stepName, final StepPlacement stepPlacement) {
        super(id);
        this.stepName = stepName;
        this.add(new Component[]{new WebMarkupContainer("master"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible("master".equals(stepName));
            }
        }});
        Object[] categories = EditorHelper.getCategory(step.getClass());
        Label stepTypeLabel = categories.length == 0 ? new Label("stepType", EditorHelper.getName(step.getClass())) : new Label("stepType", StringUtils.join((Object[])categories, (String)" > ") + " > " + EditorHelper.getName(step.getClass()));
        this.add(new Component[]{stepTypeLabel});
        WebMarkupContainer changeTypeBtn = new WebMarkupContainer("changeType");
        this.add(new Component[]{changeTypeBtn});
        changeTypeBtn.add(new Behavior[]{new TypeMenuBehavior<Step>(){

            @Override
            public void onSelect(Class<Step> stepClass) {
                Step newStep;
                try {
                    newStep = stepClass.newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                newStep.setName(step.getName());
                newStep.setDescription(step.getDescription());
                newStep.setEnabled(step.isEnabled());
                newStep.setExecuteCondition(step.getExecuteCondition());
                newStep.setNodeMatcher(step.getNodeMatcher());
                newStep.setPreExecuteAction(step.getPreExecuteAction());
                newStep.setPostExecuteAction(step.getPostExecuteAction());
                newStep.setInputOption(step.getInputOption());
                newStep.setOutputOption(step.getOutputOption());
                newStep.setRepetitions(step.getRepetitions());
                newStep.setNodePreference(step.getNodePreference());
                newStep.setTimeout(step.getTimeout());
                if (step instanceof CompositeStep && newStep instanceof CompositeStep) {
                    CompositeStep compositeStep = (CompositeStep)step;
                    CompositeStep newCompositeStep = (CompositeStep)newStep;
                    newCompositeStep.setSuccessCondition(compositeStep.getSuccessCondition());
                    newCompositeStep.setChildStepNames(compositeStep.getChildStepNames());
                }
                StepEdit stepEdit = new StepEdit(id, newStep, stepName, stepPlacement);
                StepEdit.this.replaceWith((Component)((Object)stepEdit));
            }
        }});
        String description = EditorHelper.getDescription(step.getClass());
        Label label = new Label("description", description);
        label.setEscapeModelStrings(false);
        if (description == null) {
            label.setVisible(false);
        }
        this.add(new Component[]{label});
        final EditContext editContext = "master".equals(stepName) ? new EditContext(step, Step.MASTER_EXCLUDED_PROPERTIES, true) : new EditContext(step);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(step);
                    Configuration configuration = Context.getConfiguration();
                    String auditContent = null;
                    String previousAuditContent = null;
                    String auditAction = null;
                    if (stepName == null) {
                        if (configuration.getStepNames().contains(step.getName())) {
                            editContext.getProperty("name").setError("This name is already used by another step in this configuration.");
                            this.getSession().error((Serializable)((Object)"Fix errors below."));
                        } else {
                            if (stepPlacement != null) {
                                Step stepToModify;
                                int stepPathSize;
                                if (stepPlacement.getPosition() == StepPlacement.Position.BEFORE || stepPlacement.getPosition() == StepPlacement.Position.AFTER) {
                                    stepPathSize = stepPlacement.getReferenceStepPath().size();
                                    Validate.isTrue((stepPathSize >= 2 ? 1 : 0) != 0);
                                    stepToModify = configuration.findStep(stepPlacement.getReferenceStepPath().get(stepPathSize - 2));
                                    Validate.notNull((Object)stepToModify);
                                    previousAuditContent = VersionedDocument.fromBean(stepToModify).toXML();
                                    CompositeStep referenceParentStep = (CompositeStep)stepToModify;
                                    String referenceStepName = stepPlacement.getReferenceStepPath().get(stepPathSize - 1);
                                    int referenceIndex = referenceParentStep.getChildStepNames().indexOf(referenceStepName);
                                    Validate.isTrue((referenceIndex != -1 ? 1 : 0) != 0);
                                    if (stepPlacement.getPosition() == StepPlacement.Position.BEFORE) {
                                        referenceParentStep.getChildStepNames().add(referenceIndex, step.getName());
                                    } else if (referenceIndex == referenceParentStep.getChildStepNames().size() - 1) {
                                        referenceParentStep.getChildStepNames().add(step.getName());
                                    } else {
                                        referenceParentStep.getChildStepNames().add(referenceIndex + 1, step.getName());
                                    }
                                } else {
                                    stepPathSize = stepPlacement.getReferenceStepPath().size();
                                    Validate.isTrue((stepPathSize >= 1 ? 1 : 0) != 0);
                                    stepToModify = configuration.findStep(stepPlacement.getReferenceStepPath().get(stepPathSize - 1));
                                    Validate.notNull((Object)stepToModify);
                                    previousAuditContent = VersionedDocument.fromBean(stepToModify).toXML();
                                    ((CompositeStep)stepToModify).getChildStepNames().add(step.getName());
                                }
                                VersionedDocument modifiedDom = VersionedDocument.fromBean(stepToModify);
                                auditContent = modifiedDom.toXML();
                                configuration.getStepDOMs().put(stepToModify.getName(), modifiedDom);
                                auditAction = "Step '" + stepToModify.getName() + "' was modified.";
                            }
                            ConfigurationManager.instance.saveStep(configuration, step, null);
                            if (auditAction != null) {
                                AuditManager.instance.audit(configuration, auditAction, auditContent, previousAuditContent);
                            }
                            AuditManager.instance.audit(configuration, "Step '" + step.getName() + "' was added.");
                            PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "steps");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"New step added."));
                        }
                    } else {
                        VersionedDocument dom = StepEdit.this.getDom(stepName);
                        if (dom != null) {
                            if (!step.getName().equals(stepName) && StepEdit.this.getDom(step.getName()) != null) {
                                editContext.getProperty("name").setError("This name is already used by another step in this configuration.");
                                this.getSession().error((Serializable)((Object)"Fix errors below."));
                            } else {
                                ConfigurationManager.instance.saveStep(configuration, step, stepName);
                                AuditManager.instance.audit(configuration, "Step '" + step.getName() + "' was modified.", VersionedDocument.fromBean(step).toXML(), dom.toXML());
                                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "steps");
                                this.setResponsePage(ConfigurationSettingPage.class, params);
                                this.getSession().info((Serializable)((Object)"Setting saved."));
                            }
                        } else {
                            ConfigurationManager.instance.saveStep(configuration, step, null);
                            AuditManager.instance.audit(configuration, "Step '" + step.getName() + "' was added.");
                            PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "steps");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"Setting saved."));
                        }
                    }
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "steps");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }

    private VersionedDocument getDom(String stepName) {
        return Context.getConfiguration().getStepDOMs().get(stepName);
    }

    public String getStepName() {
        return this.stepName;
    }
}

