/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class RepositoryUsagesPanel
extends Panel {
    private final String repositoryName;
    private IModel<List<RepositoryUsage>> usagesModel = new LoadableDetachableModel<List<RepositoryUsage>>(){

        protected List<RepositoryUsage> load() {
            return this.findUsages(Context.getConfiguration());
        }

        List<RepositoryUsage> findUsages(Configuration configuration) {
            ArrayList<RepositoryUsage> usages = new ArrayList<RepositoryUsage>();
            RepositoryUsage usage = new RepositoryUsage();
            usage.setConfiguration(configuration);
            for (Step step : configuration.getSteps().values()) {
                RepositoryStep repositoryStep;
                if (!(step instanceof RepositoryStep) || !(repositoryStep = (RepositoryStep)step).getRepositoryName().equals(RepositoryUsagesPanel.this.repositoryName)) continue;
                usage.getStepNames().add(step.getName());
            }
            if (!usage.getStepNames().isEmpty()) {
                usages.add(usage);
            }
            for (Configuration child : configuration.getChildren()) {
                if (child.getRepositoryDOMs().containsKey(RepositoryUsagesPanel.this.repositoryName)) continue;
                usages.addAll(this.findUsages(child));
            }
            return usages;
        }
    };

    public RepositoryUsagesPanel(String id, String repositoryName) {
        super(id);
        this.repositoryName = repositoryName;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (((List)RepositoryUsagesPanel.this.usagesModel.getObject()).isEmpty()) {
                    return "No any steps using repository '" + RepositoryUsagesPanel.this.repositoryName + "'";
                }
                return "Steps using repository '" + RepositoryUsagesPanel.this.repositoryName + "'";
            }
        })});
        this.add(new Component[]{new ListView<RepositoryUsage>("usages", this.usagesModel){

            protected void populateItem(final ListItem<RepositoryUsage> item) {
                BookmarkablePageLink<Void> link = new BookmarkablePageLink<Void>("link", ConfigurationSettingPage.class, ConfigurationSettingPage.params4(((RepositoryUsage)item.getModelObject()).getConfiguration().getId(), "steps")){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setEnabled(SecurityHelper.hasPermission(((RepositoryUsage)item.getModelObject()).getConfiguration()));
                    }
                };
                Label label = new Label("label", ((RepositoryUsage)item.getModelObject()).getConfiguration().getPathName());
                label.setRenderBodyOnly(true);
                link.add(new Component[]{label});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("steps", StringUtils.join(((RepositoryUsage)item.getModelObject()).getStepNames()))});
            }
        }});
    }

    protected void onDetach() {
        this.usagesModel.detach();
        super.onDetach();
    }

    private static class RepositoryUsage {
        private Configuration configuration;
        private List<String> stepNames = new ArrayList<String>();

        private RepositoryUsage() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public List<String> getStepNames() {
            return this.stepNames;
        }
    }
}

