/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class RepositoryOverridesPanel
extends Panel {
    private final String repositoryName;
    private IModel<List<Configuration>> overridesModel = new LoadableDetachableModel<List<Configuration>>(){

        protected List<Configuration> load() {
            return this.findOverrides(Context.getConfiguration());
        }

        List<Configuration> findOverrides(Configuration configuration) {
            ArrayList<Configuration> overrides = new ArrayList<Configuration>();
            for (Configuration child : configuration.getChildren()) {
                if (child.getRepositoryDOMs().containsKey(RepositoryOverridesPanel.this.repositoryName)) {
                    overrides.add(child);
                    continue;
                }
                overrides.addAll(this.findOverrides(child));
            }
            return overrides;
        }
    };

    public RepositoryOverridesPanel(String id, String repositoryName) {
        super(id);
        this.repositoryName = repositoryName;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (((List)RepositoryOverridesPanel.this.overridesModel.getObject()).isEmpty()) {
                    return "Found no overrides of repository '" + RepositoryOverridesPanel.this.repositoryName + "'";
                }
                return "Configurations overriding repository '" + RepositoryOverridesPanel.this.repositoryName + "'";
            }
        })});
        this.add(new Component[]{new ListView<Configuration>("overrides", this.overridesModel){

            protected void populateItem(final ListItem<Configuration> item) {
                BookmarkablePageLink<Void> link = new BookmarkablePageLink<Void>("link", ConfigurationSettingPage.class, ConfigurationSettingPage.params4(((Configuration)item.getModelObject()).getId(), "repositories")){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setEnabled(SecurityHelper.hasPermission((Configuration)item.getModelObject()));
                    }
                };
                Label label = new Label("label", ((Configuration)item.getModelObject()).getPathName());
                label.setRenderBodyOnly(true);
                link.add(new Component[]{label});
                item.add(new Component[]{link});
            }
        }});
    }

    protected void onDetach() {
        this.overridesModel.detach();
        super.onDetach();
    }
}

