/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.repository.usermapping.ListMapping;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class RepositoryEdit
extends Panel {
    public RepositoryEdit(final String id, final Repository<?> repository, final String repositoryName) {
        super(id);
        this.add(new Component[]{new Label("repositoryType", EditorHelper.getName(repository.getClass()))});
        WebMarkupContainer changeTypeBtn = new WebMarkupContainer("changeType");
        this.add(new Component[]{changeTypeBtn});
        changeTypeBtn.add(new Behavior[]{new TypeMenuBehavior<Repository<?>>(){

            @Override
            public void onSelect(Class<Repository<?>> repositoryClass) {
                Repository<?> newRepository;
                try {
                    newRepository = repositoryClass.newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                newRepository.setName(repository.getName());
                newRepository.setDescription(repository.getDescription());
                newRepository.setQuietPeriod(repository.getQuietPeriod());
                newRepository.setUserMapping(repository.getUserMapping());
                RepositoryEdit repositoryEdit = new RepositoryEdit(id, newRepository, repositoryName);
                RepositoryEdit.this.replaceWith((Component)((Object)repositoryEdit));
            }
        }});
        String description = EditorHelper.getDescription(repository.getClass());
        Label label = new Label("description", description);
        label.setEscapeModelStrings(false);
        if (description == null) {
            label.setVisible(false);
        }
        this.add(new Component[]{label});
        final EditContext editContext = new EditContext(repository);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(repository);
                    if (repository.getUserMapping() instanceof ListMapping) {
                        ListMapping mapping = (ListMapping)repository.getUserMapping();
                        Collections.sort(mapping.getEntries());
                    }
                    Configuration configuration = Context.getConfiguration();
                    if (repositoryName == null) {
                        if (configuration.getRepositoryNames().contains(repository.getName())) {
                            editContext.getProperty("name").setError("This name is already used by another repository in this configuration.");
                            this.getSession().error((Serializable)((Object)"Fix errors below."));
                        } else {
                            ConfigurationManager.instance.saveRepository(configuration, repository, null);
                            AuditManager.instance.audit(configuration, "Repository '" + repository.getName() + "' was added.");
                            PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "repositories");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"New repository saved."));
                        }
                    } else {
                        VersionedDocument dom = RepositoryEdit.this.getDom(repositoryName);
                        if (dom != null) {
                            if (!repository.getName().equals(repositoryName) && RepositoryEdit.this.getDom(repository.getName()) != null) {
                                editContext.getProperty("name").setError("This name is already used by another repository in this configuration.");
                                this.getSession().error((Serializable)((Object)"Fix errors below."));
                            } else {
                                ConfigurationManager.instance.saveRepository(configuration, repository, repositoryName);
                                AuditManager.instance.audit(configuration, "Repository '" + repository.getName() + "' was modified.", VersionedDocument.fromBean(repository).toXML(), dom.toXML());
                                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "repositories");
                                this.setResponsePage(ConfigurationSettingPage.class, params);
                                this.getSession().info((Serializable)((Object)"Setting saved."));
                            }
                        } else {
                            ConfigurationManager.instance.saveRepository(configuration, repository, null);
                            AuditManager.instance.audit(configuration, "Repository '" + repository.getName() + "' was overwrited from parent.");
                            PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "repositories");
                            this.setResponsePage(ConfigurationSettingPage.class, params);
                            this.getSession().info((Serializable)((Object)"Setting saved."));
                        }
                    }
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "repositories");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }

    private VersionedDocument getDom(String repositoryName) {
        return Context.getConfiguration().getRepositoryDOMs().get(repositoryName);
    }
}

