/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.FailSafeRepository;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.behavior.menu.TypeMenuBehavior;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.configuration.ConfigurationSubordinateChooser;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.RepositoryEdit;
import com.pmease.quickbuild.web.page.setting.RepositoryOverridesPanel;
import com.pmease.quickbuild.web.page.setting.RepositoryUsagesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class RepositoriesPanel
extends Panel {
    public static final String SETTING_NAME = "repositories";
    private SelectionColumn<Repository<?>> selectionColumn;

    public RepositoriesPanel(final String id) {
        super(id);
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isEditSettingAllowed());
            }
        };
        this.add(new Component[]{operations});
        WebMarkupContainer addNewBtn = new WebMarkupContainer("addNew");
        operations.add(new Component[]{addNewBtn});
        addNewBtn.add(new Behavior[]{new TypeMenuBehavior<Repository<?>>(){

            @Override
            protected void onSelect(Class<Repository<?>> repositoryClass) {
                try {
                    RepositoryEdit repositoryEdit = new RepositoryEdit(id, repositoryClass.newInstance(), null);
                    RepositoriesPanel.this.replaceWith((Component)((Object)repositoryEdit));
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
        }});
        operations.add(new Component[]{new WebMarkupContainer("copyFrom").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationSubordinateChooser(componentId){

                    @Override
                    protected List<String> getSubordinateNames(Configuration configuration) {
                        ArrayList<String> objectNames = new ArrayList<String>();
                        objectNames.addAll(configuration.getRepositoryNames());
                        Collections.sort(objectNames);
                        return objectNames;
                    }

                    @Override
                    protected void subordinateSelected(Configuration configuration, String objectName) {
                        Repository<?> repository = configuration.findRepository(objectName);
                        Validate.notNull(repository);
                        RepositoriesPanel.this.replaceWith((Component)((Object)new RepositoryEdit(id, repository, null)));
                    }
                };
            }
        }})});
        operations.add(new Component[]{new Link<Void>("deleteSelected"){

            public void onClick() {
                Configuration configuration = Context.getConfiguration();
                Set<String> repositoryNames = configuration.getRepositoryNames();
                for (Repository repository : RepositoriesPanel.this.selectionColumn.getSelections()) {
                    if (!repositoryNames.contains(repository.getName())) {
                        this.getSession().warn((Serializable)((Object)("Can not delete inherited repository: " + repository.getName())));
                        continue;
                    }
                    ConfigurationManager.instance.deleteRepository(configuration, repository.getName());
                    AuditManager.instance.audit(configuration, "Repository '" + repository.getName() + "' was deleted.");
                }
                RepositoriesPanel.this.selectionColumn.getSelections().clear();
            }
        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected repositories?")})});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isEditSettingAllowed()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Repository<?>>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Repository<?>>> cellItem, String componentId, IModel<Repository<?>> rowModel) {
                Fragment fragment = new Fragment(componentId, "nameFrag", (MarkupContainer)RepositoriesPanel.this);
                cellItem.add(new Component[]{fragment});
                cellItem.add(new Behavior[]{new AttributeModifier("nowrap", (Serializable)((Object)"true"))});
                final Repository repository = (Repository)rowModel.getObject();
                Configuration current = Context.getConfiguration();
                Configuration declarer = current.findRepositoryDeclarer(repository.getName());
                Validate.notNull((Object)declarer);
                Configuration override = current.getParent();
                if (override != null) {
                    override = override.findRepositoryDeclarer(repository.getName());
                }
                final boolean inherited = !current.getId().equals(declarer.getId());
                fragment.add(new Component[]{new Label("name", repository.getName()).add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        if (repository instanceof FailSafeRepository) {
                            return new Label(componentId, repository.getDescription());
                        }
                        return new BeanViewer(componentId, new ViewContext(repository));
                    }
                }.hoverMode(true)})});
                Component[] componentArray = new Component[1];
                Link<Void> link = new Link<Void>("edit"){

                    public void onClick() {
                        RepositoriesPanel.this.replaceWith((Component)((Object)new RepositoryEdit(id, repository, repository.getName())));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                };
                componentArray[0] = link;
                fragment.add(componentArray);
                link.add(new Component[]{new WebMarkupContainer("icon"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                        tag.put("title", (CharSequence)(inherited ? "Overwrite this repository" : "Edit this repository"));
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        RepositoriesPanel.this.replaceWith((Component)((Object)new RepositoryEdit(id, repository, null)));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                }});
                WebMarkupContainer findLink = new WebMarkupContainer("find");
                findLink.setVisible(!inherited);
                findLink.add(new Behavior[]{new MenuBehavior(){

                    @Override
                    protected List<MenuItem> getMenuItems() {
                        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                        menuItems.add(new MenuItem(){

                            @Override
                            public Component render(String componentId) {
                                return new TextLink<Void>(componentId, "Find Overrides"){

                                    public void onClick() {
                                        RepositoriesPanel.this.replaceWith((Component)((Object)new RepositoryOverridesPanel(id, repository.getName())));
                                    }
                                };
                            }
                        });
                        menuItems.add(new MenuItem(){

                            @Override
                            public Component render(String componentId) {
                                return new TextLink<Void>(componentId, "Find Steps Using this Repository"){

                                    public void onClick() {
                                        RepositoriesPanel.this.replaceWith((Component)((Object)new RepositoryUsagesPanel(id, repository.getName())));
                                    }
                                };
                            }
                        });
                        return menuItems;
                    }
                }});
                fragment.add(new Component[]{findLink});
                fragment.add(new Component[]{new InheritIndicator("inherit", declarer, override, RepositoriesPanel.SETTING_NAME)});
            }
        });
        columns.add(new AbstractColumn<Repository<?>>((IModel)new Model((Serializable)((Object)"Type"))){

            public void populateItem(Item<ICellPopulator<Repository<?>>> cellItem, String componentId, IModel<Repository<?>> rowModel) {
                Repository repository = (Repository)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, EditorHelper.getName(repository.getClass()))});
                if (repository instanceof FailSafeRepository) {
                    cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"red"))});
                }
                cellItem.add(new Behavior[]{new AttributeModifier("nowrap", (Serializable)((Object)"true"))});
            }
        });
        columns.add(new AbstractColumn<Repository<?>>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Repository<?>>> cellItem, String componentId, IModel<Repository<?>> rowModel) {
                Repository repository = (Repository)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, repository.getDescription())});
            }
        });
        this.add(new Component[]{new DefaultDataTable(SETTING_NAME, columns, (ISortableDataProvider)new DataProvider<Repository<?>>(){

            public Iterator<? extends Repository<?>> iterator(int first, int count) {
                Map<String, Repository<?>> map = Context.getConfiguration().findRepositories();
                ArrayList list = new ArrayList(map.values());
                Collections.sort(list, new Comparator<Repository<?>>(){

                    @Override
                    public int compare(Repository<?> repository1, Repository<?> repository2) {
                        return repository1.getName().compareTo(repository2.getName());
                    }
                });
                return list.iterator();
            }

            public int size() {
                return Context.getConfiguration().findRepositoryNames().size();
            }
        }, Integer.MAX_VALUE)});
    }
}

