/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.SortBehavior;
import com.pmease.quickbuild.web.behavior.SortPosition;
import com.pmease.quickbuild.web.component.configuration.ConfigurationSubordinateChooser;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.setting.PromotionEdit;
import com.pmease.quickbuild.web.page.setting.PromotionOverridesPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PromotionsPanel
extends Panel {
    public static final String SETTING_NAME = "promotions";
    private SelectionColumn<Promotion> selectionColumn;

    public PromotionsPanel(final String id) {
        super(id);
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isEditSettingAllowed());
            }
        };
        this.add(new Component[]{operations});
        operations.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                PromotionsPanel.this.replaceWith((Component)((Object)new PromotionEdit(id, new Promotion(), null)));
            }
        }});
        operations.add(new Component[]{new WebMarkupContainer("copyFrom").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationSubordinateChooser(componentId){

                    @Override
                    protected List<String> getSubordinateNames(Configuration configuration) {
                        ArrayList<String> subordinateNames = new ArrayList<String>();
                        subordinateNames.addAll(configuration.getPromotionNames());
                        Collections.sort(subordinateNames);
                        return subordinateNames;
                    }

                    @Override
                    protected void subordinateSelected(Configuration configuration, String subordinateName) {
                        Promotion promotion = configuration.findPromotion(subordinateName);
                        Validate.notNull((Object)promotion);
                        PromotionsPanel.this.replaceWith((Component)((Object)new PromotionEdit(id, promotion, null)));
                    }
                };
            }
        }})});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteSelected"){

            public void onClick() {
                Configuration configuration = Context.getConfiguration();
                for (Promotion promotion : PromotionsPanel.this.selectionColumn.getSelections()) {
                    boolean found = false;
                    Iterator<Promotion> it = configuration.getPromotions().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getName().equals(promotion.getName())) continue;
                        it.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getSession().warn((Serializable)((Object)("Can not delete inherited promotion: " + promotion.getName())));
                }
                ConfigurationManager.instance.savePromotions(configuration);
                for (Promotion promotion : PromotionsPanel.this.selectionColumn.getSelections()) {
                    AuditManager.instance.audit(configuration, "Promotion '" + promotion.getName() + "' was deleted.");
                }
                PromotionsPanel.this.selectionColumn.getSelections().clear();
            }
        };
        componentArray[0] = link;
        operations.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected promotions?")});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.isEditSettingAllowed()) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Promotion>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Promotion>> cellItem, String componentId, IModel<Promotion> rowModel) {
                Fragment fragment = new Fragment(componentId, "nameFrag", (MarkupContainer)PromotionsPanel.this);
                cellItem.add(new Component[]{fragment});
                final Promotion promotion = (Promotion)rowModel.getObject();
                Configuration configuration = Context.getConfiguration();
                Configuration declarer = configuration.findPromotionDeclarer(promotion.getName());
                Validate.notNull((Object)declarer);
                Configuration override = configuration.getParent();
                if (override != null) {
                    override = override.findPromotionDeclarer(promotion.getName());
                }
                final boolean inherited = !declarer.getId().equals(configuration.getId());
                fragment.add(new Component[]{new Label("name", promotion.getName()).add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        return new BeanViewer(componentId, new ViewContext(promotion));
                    }
                }.hoverMode(true)})});
                Component[] componentArray = new Component[1];
                Link<Void> link = new Link<Void>("edit"){

                    public void onClick() {
                        PromotionsPanel.this.replaceWith((Component)((Object)new PromotionEdit(id, promotion, promotion.getName())));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                };
                componentArray[0] = link;
                fragment.add(componentArray);
                link.add(new Component[]{new WebMarkupContainer("icon"){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("src", (CharSequence)(inherited ? "/images/overwrite.png" : "/images/edit.png"));
                        tag.put("title", (CharSequence)(inherited ? "Overwrite this promotion" : "Edit this promotion"));
                    }
                }});
                WebMarkupContainer dragHandle = new WebMarkupContainer("dragHandle");
                dragHandle.setVisible(!inherited && SecurityHelper.isEditSettingAllowed());
                fragment.add(new Component[]{dragHandle});
                fragment.add(new Component[]{new InheritIndicator("inherit", declarer, override, PromotionsPanel.SETTING_NAME)});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        PromotionsPanel.this.replaceWith((Component)((Object)new PromotionEdit(id, promotion, null)));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isEditSettingAllowed());
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("find"){

                    public void onClick() {
                        PromotionsPanel.this.replaceWith((Component)((Object)new PromotionOverridesPanel(id, promotion.getName())));
                    }
                }.setVisible(!inherited)});
            }
        });
        columns.add(new AbstractColumn<Promotion>((IModel)new Model((Serializable)((Object)"Condition"))){

            public void populateItem(Item<ICellPopulator<Promotion>> cellItem, String componentId, IModel<Promotion> rowModel) {
                Promotion promotion = (Promotion)rowModel.getObject();
                ViewContext.ViewableProperty property = new ViewContext(promotion).getProperty("condition");
                cellItem.add(new Component[]{new PropertyViewer(componentId, Promotion.class, property)});
            }
        });
        columns.add(new AbstractColumn<Promotion>((IModel)new Model((Serializable)((Object)"Server"))){

            public void populateItem(Item<ICellPopulator<Promotion>> cellItem, String componentId, IModel<Promotion> rowModel) {
                Promotion promotion = (Promotion)rowModel.getObject();
                if (promotion.getServer() != null) {
                    cellItem.add(new Component[]{new BeanViewer(componentId, new ViewContext(promotion.getServer()))});
                } else {
                    Label label = new Label(componentId, "<i>This server</i>");
                    label.setEscapeModelStrings(false);
                    cellItem.add(new Component[]{label});
                }
            }
        });
        columns.add(new AbstractColumn<Promotion>((IModel)new Model((Serializable)((Object)"Configuration"))){

            public void populateItem(Item<ICellPopulator<Promotion>> cellItem, String componentId, IModel<Promotion> rowModel) {
                Promotion promotion = (Promotion)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, promotion.getConfigurationPath())});
            }
        });
        columns.add(new AbstractColumn<Promotion>((IModel)new Model((Serializable)((Object)"Auto Promote"))){

            public void populateItem(Item<ICellPopulator<Promotion>> cellItem, String componentId, IModel<Promotion> rowModel) {
                Promotion promotion = (Promotion)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(promotion.isAutoPromote()))});
            }
        });
        DefaultDataTable<Promotion> dataTable = new DefaultDataTable<Promotion>(SETTING_NAME, columns, (ISortableDataProvider)new DataProvider<Promotion>(){

            public Iterator<Promotion> iterator(int first, int count) {
                return Context.getConfiguration().findPromotions().iterator();
            }

            public int size() {
                return Context.getConfiguration().findPromotions().size();
            }
        }, Integer.MAX_VALUE){

            protected Item<Promotion> newRowItem(String id, int index, IModel<Promotion> model) {
                boolean inherited;
                Item item = super.newRowItem(id, index, model);
                Promotion promotion = (Promotion)item.getModelObject();
                Configuration configuration = Context.getConfiguration();
                Configuration declarer = configuration.findPromotionDeclarer(promotion.getName());
                Validate.notNull((Object)declarer);
                boolean bl = inherited = !declarer.getId().equals(configuration.getId());
                if (!inherited) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"sortable")), " ")});
                }
                return item;
            }
        };
        this.add(new Component[]{dataTable});
        if (SecurityHelper.isEditSettingAllowed()) {
            dataTable.add(new Behavior[]{new SortBehavior(){

                @Override
                public void onSort(AjaxRequestTarget target, SortPosition from, SortPosition to) {
                    Promotion promotion = Context.getConfiguration().getPromotions().remove(from.getItemIndex());
                    Context.getConfiguration().getPromotions().add(to.getItemIndex(), promotion);
                    ConfigurationManager.instance.savePromotions(Context.getConfiguration());
                }
            }.sortable(">tbody").handle(".ui-draggable").items("tr.sortable")});
        }
    }
}

