/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class PromotionEdit
extends Panel {
    public PromotionEdit(String id, final Promotion promotion, final String name) {
        super(id);
        final EditContext editContext = new EditContext(promotion);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                String error = null;
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(promotion);
                    Configuration configuration = Context.getConfiguration();
                    if (name == null) {
                        if (configuration.getPromotion(promotion.getName()) != null) {
                            editContext.getProperty("name").setError("This name is already used by another promotion in this configuration.");
                            error = "Fix errors below.";
                        } else {
                            configuration.getPromotions().add(promotion);
                            ConfigurationManager.instance.savePromotions(configuration);
                            AuditManager.instance.audit(configuration, "Promotion '" + promotion.getName() + "' was added.");
                            this.getSession().info((Serializable)((Object)"New promotion saved."));
                        }
                    } else {
                        Promotion existing = configuration.getPromotion(name);
                        if (existing != null) {
                            if (!promotion.getName().equals(name) && configuration.getPromotion(promotion.getName()) != null) {
                                editContext.getProperty("name").setError("This name is already used by another promotion in this configuration.");
                                error = "Fix errors below.";
                            } else {
                                String previousAuditContent = VersionedDocument.fromBean(existing).toXML();
                                existing.setCondition(promotion.getCondition());
                                existing.setConfigurationPath(promotion.getConfigurationPath());
                                existing.setDeliveries(promotion.getDeliveries());
                                existing.setName(promotion.getName());
                                existing.setAutoPromote(promotion.isAutoPromote());
                                existing.setServer(promotion.getServer());
                                existing.setPromptConfVars(promotion.isPromptConfVars());
                                existing.setVariables(promotion.getVariables());
                                ConfigurationManager.instance.savePromotions(configuration);
                                AuditManager.instance.audit(configuration, "Promotion '" + promotion.getName() + "' was modified.", VersionedDocument.fromBean(existing).toXML(), previousAuditContent);
                                this.getSession().info((Serializable)((Object)"Setting saved."));
                            }
                        } else {
                            configuration.getPromotions().add(promotion);
                            ConfigurationManager.instance.savePromotions(configuration);
                            AuditManager.instance.audit(configuration, "Promotion '" + promotion.getName() + "' was overwrited from parent.");
                            this.getSession().info((Serializable)((Object)"Setting saved."));
                        }
                    }
                } else {
                    error = "Fix errors below.";
                }
                if (error == null) {
                    PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "promotions");
                    this.setResponsePage(ConfigurationSettingPage.class, params);
                } else {
                    this.getSession().error((Serializable)((Object)error));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                PageParameters params = ConfigurationSettingPage.params4(Context.getConfiguration().getId(), "promotions");
                this.setResponsePage(ConfigurationSettingPage.class, params);
            }
        }});
        this.add(new Component[]{form});
    }
}

